@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enableDefaultValidation
 * @property resourceTypesWithCustomValidation
 */
public data class ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs(
    public val enableDefaultValidation: Output<Boolean>? = null,
    public val resourceTypesWithCustomValidation: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs.builder()
            .enableDefaultValidation(enableDefaultValidation?.applyValue({ args0 -> args0 }))
            .resourceTypesWithCustomValidation(
                resourceTypesWithCustomValidation?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgsBuilder
internal constructor() {
    private var enableDefaultValidation: Output<Boolean>? = null

    private var resourceTypesWithCustomValidation: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("hnrnmscvsonodgpr")
    public suspend fun enableDefaultValidation(`value`: Output<Boolean>) {
        this.enableDefaultValidation = value
    }

    /**
     * @param value
     */
    @JvmName("ecpyjwirovbcoxcw")
    public suspend fun resourceTypesWithCustomValidation(`value`: Output<List<String>>) {
        this.resourceTypesWithCustomValidation = value
    }

    @JvmName("eqdhgsordyogbjmf")
    public suspend fun resourceTypesWithCustomValidation(vararg values: Output<String>) {
        this.resourceTypesWithCustomValidation = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("eeqtephogwlgstvq")
    public suspend fun resourceTypesWithCustomValidation(values: List<Output<String>>) {
        this.resourceTypesWithCustomValidation = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gqrgcjpdaqhfnaal")
    public suspend fun enableDefaultValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultValidation = mapped
    }

    /**
     * @param value
     */
    @JvmName("xuboibtsintdonik")
    public suspend fun resourceTypesWithCustomValidation(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesWithCustomValidation = mapped
    }

    /**
     * @param values
     */
    @JvmName("musosendmhrnqnbu")
    public suspend fun resourceTypesWithCustomValidation(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesWithCustomValidation = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs =
        ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecificationsArgs(
            enableDefaultValidation = enableDefaultValidation,
            resourceTypesWithCustomValidation = resourceTypesWithCustomValidation,
        )
}
