@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.OptInHeaderType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optInHeaders
 */
public data class ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs(
    public val optInHeaders: Output<Either<String, OptInHeaderType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs.builder()
            .optInHeaders(
                optInHeaders?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgsBuilder internal
constructor() {
    private var optInHeaders: Output<Either<String, OptInHeaderType>>? = null

    /**
     * @param value
     */
    @JvmName("ubllvrytbkkodony")
    public suspend fun optInHeaders(`value`: Output<Either<String, OptInHeaderType>>) {
        this.optInHeaders = value
    }

    /**
     * @param value
     */
    @JvmName("kacpmtyfpiflbgis")
    public suspend fun optInHeaders(`value`: Either<String, OptInHeaderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    /**
     * @param value
     */
    @JvmName("aknimvclblnlfqpa")
    public fun optInHeaders(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OptInHeaderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    /**
     * @param value
     */
    @JvmName("jixeqbfrougspana")
    public fun optInHeaders(`value`: OptInHeaderType) {
        val toBeMapped = Either.ofRight<String, OptInHeaderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs =
        ResourceTypeRegistrationPropertiesRequestHeaderOptionsArgs(
            optInHeaders = optInHeaders,
        )
}
