@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property softDeleteTTL
 * @property subscriptionStateOverrideActions
 */
public data class
ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs(
    public val softDeleteTTL: Output<String>? = null,
    public val subscriptionStateOverrideActions: Output<List<SubscriptionStateOverrideActionArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs.builder()
            .softDeleteTTL(softDeleteTTL?.applyValue({ args0 -> args0 }))
            .subscriptionStateOverrideActions(
                subscriptionStateOverrideActions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs].
 */
@PulumiTagMarker
public class
ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder
internal constructor() {
    private var softDeleteTTL: Output<String>? = null

    private var subscriptionStateOverrideActions: Output<List<SubscriptionStateOverrideActionArgs>>? =
        null

    /**
     * @param value
     */
    @JvmName("xxyvdpebmenxrceu")
    public suspend fun softDeleteTTL(`value`: Output<String>) {
        this.softDeleteTTL = value
    }

    /**
     * @param value
     */
    @JvmName("qvnahufbgwsfyrvh")
    public suspend
    fun subscriptionStateOverrideActions(`value`: Output<List<SubscriptionStateOverrideActionArgs>>) {
        this.subscriptionStateOverrideActions = value
    }

    @JvmName("fgtedmpaueauochr")
    public suspend fun subscriptionStateOverrideActions(
        vararg
        values: Output<SubscriptionStateOverrideActionArgs>,
    ) {
        this.subscriptionStateOverrideActions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fyvcyxovtomrudtw")
    public suspend
    fun subscriptionStateOverrideActions(values: List<Output<SubscriptionStateOverrideActionArgs>>) {
        this.subscriptionStateOverrideActions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gitlwckewsxojnip")
    public suspend fun softDeleteTTL(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteTTL = mapped
    }

    /**
     * @param value
     */
    @JvmName("qxunhtlovqfvrjyv")
    public suspend
    fun subscriptionStateOverrideActions(`value`: List<SubscriptionStateOverrideActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionStateOverrideActions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bgkbldmctpgdfkvi")
    public suspend
    fun subscriptionStateOverrideActions(argument: List<suspend SubscriptionStateOverrideActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateOverrideActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateOverrideActions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("svkidglnnkrclxwc")
    public suspend fun subscriptionStateOverrideActions(
        vararg
        argument: suspend SubscriptionStateOverrideActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubscriptionStateOverrideActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subscriptionStateOverrideActions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cmftfmipgpmmdxos")
    public suspend
    fun subscriptionStateOverrideActions(argument: suspend SubscriptionStateOverrideActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SubscriptionStateOverrideActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subscriptionStateOverrideActions = mapped
    }

    /**
     * @param values
     */
    @JvmName("plkgfhsenfxjbked")
    public suspend fun subscriptionStateOverrideActions(
        vararg
        values: SubscriptionStateOverrideActionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionStateOverrideActions = mapped
    }

    internal fun build():
        ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs =
        ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs(
            softDeleteTTL = softDeleteTTL,
            subscriptionStateOverrideActions = subscriptionStateOverrideActions,
        )
}
