@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property capacity
 * @property costs
 * @property family
 * @property kind
 * @property locationInfo
 * @property locations
 * @property name
 * @property requiredFeatures
 * @property requiredQuotaIds
 * @property size
 * @property tier
 */
public data class SkuSettingArgs(
    public val capabilities: Output<List<SkuCapabilityArgs>>? = null,
    public val capacity: Output<SkuSettingCapacityArgs>? = null,
    public val costs: Output<List<SkuCostArgs>>? = null,
    public val family: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val locationInfo: Output<List<SkuLocationInfoArgs>>? = null,
    public val locations: Output<List<String>>? = null,
    public val name: Output<String>,
    public val requiredFeatures: Output<List<String>>? = null,
    public val requiredQuotaIds: Output<List<String>>? = null,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .costs(costs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .family(family?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .locationInfo(
                locationInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredQuotaIds(requiredQuotaIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuSettingArgs].
 */
@PulumiTagMarker
public class SkuSettingArgsBuilder internal constructor() {
    private var capabilities: Output<List<SkuCapabilityArgs>>? = null

    private var capacity: Output<SkuSettingCapacityArgs>? = null

    private var costs: Output<List<SkuCostArgs>>? = null

    private var family: Output<String>? = null

    private var kind: Output<String>? = null

    private var locationInfo: Output<List<SkuLocationInfoArgs>>? = null

    private var locations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var requiredQuotaIds: Output<List<String>>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("aqjdgrpqrsgilsji")
    public suspend fun capabilities(`value`: Output<List<SkuCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("gqfyyobeyamvubdh")
    public suspend fun capabilities(vararg values: Output<SkuCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kxwpnuxalgyatukv")
    public suspend fun capabilities(values: List<Output<SkuCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tcbowwkvafxtthmd")
    public suspend fun capacity(`value`: Output<SkuSettingCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value
     */
    @JvmName("ybvyfhepockogdnx")
    public suspend fun costs(`value`: Output<List<SkuCostArgs>>) {
        this.costs = value
    }

    @JvmName("uabyygkjnpafwpwy")
    public suspend fun costs(vararg values: Output<SkuCostArgs>) {
        this.costs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mnxmqxkqgxoocbir")
    public suspend fun costs(values: List<Output<SkuCostArgs>>) {
        this.costs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tjlipssxlhvxngnt")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value
     */
    @JvmName("toquqqjiqyolbhcr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("rufklniwmbyqexey")
    public suspend fun locationInfo(`value`: Output<List<SkuLocationInfoArgs>>) {
        this.locationInfo = value
    }

    @JvmName("kurbowoxosubivup")
    public suspend fun locationInfo(vararg values: Output<SkuLocationInfoArgs>) {
        this.locationInfo = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qmmpekqonrhvuixf")
    public suspend fun locationInfo(values: List<Output<SkuLocationInfoArgs>>) {
        this.locationInfo = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hihxuuwisgsfbnoh")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("kfchmwtyduchvwpm")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dfnlntkfbbjvulmh")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("uyftoeirurgwbynf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("smnccwaamqgdmfll")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("ueghxoxsribvhdds")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ktdyqynnbvmacfgw")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nfcwkceyljohudip")
    public suspend fun requiredQuotaIds(`value`: Output<List<String>>) {
        this.requiredQuotaIds = value
    }

    @JvmName("qkfnfwfcaogoloit")
    public suspend fun requiredQuotaIds(vararg values: Output<String>) {
        this.requiredQuotaIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vlonqqfktjbqhgkg")
    public suspend fun requiredQuotaIds(values: List<Output<String>>) {
        this.requiredQuotaIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ybugmuuiwmwedmgr")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value
     */
    @JvmName("yeykgygvoeklysws")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value
     */
    @JvmName("gcowsnllmlromwra")
    public suspend fun capabilities(`value`: List<SkuCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yhmpecknjqvusykw")
    public suspend fun capabilities(argument: List<suspend SkuCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("euaxfmwxyjdamkxm")
    public suspend fun capabilities(vararg argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xrgcbbwnliqxiofk")
    public suspend fun capabilities(argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("lnuxtbkcpkjpjixc")
    public suspend fun capabilities(vararg values: SkuCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("gpjrgqsytmuucwyr")
    public suspend fun capacity(`value`: SkuSettingCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("laceinogeajqwvjn")
    public suspend fun capacity(argument: suspend SkuSettingCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = SkuSettingCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("ylsgdkghvrpgypff")
    public suspend fun costs(`value`: List<SkuCostArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hbrjrpjxonhpobms")
    public suspend fun costs(argument: List<suspend SkuCostArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qjgqmxlreclbthpj")
    public suspend fun costs(vararg argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gricmxylvdufwgnf")
    public suspend fun costs(argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCostArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param values
     */
    @JvmName("pqyjypfcbhyesovw")
    public suspend fun costs(vararg values: SkuCostArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param value
     */
    @JvmName("tatjrifilgqeboye")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value
     */
    @JvmName("mhpavsetbqxsxdwf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghvbiipmmhyntonm")
    public suspend fun locationInfo(`value`: List<SkuLocationInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iywucbgggkvvxery")
    public suspend fun locationInfo(argument: List<suspend SkuLocationInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xybtdjiuaifxdgbr")
    public suspend fun locationInfo(vararg argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ydenqnpiejuajvnr")
    public suspend fun locationInfo(argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuLocationInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param values
     */
    @JvmName("cnccvcuxkegrycrs")
    public suspend fun locationInfo(vararg values: SkuLocationInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param value
     */
    @JvmName("quoysnfrjcrvexqm")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("gqmuxksbpoxhqgmx")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("cpqifffdwhexxjax")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxrwoqrgbepjasuv")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("fvkuftxbyuxxxsdn")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("irgtspdkljuwehxg")
    public suspend fun requiredQuotaIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("hedgsfbfdycwedtc")
    public suspend fun requiredQuotaIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("baukpthgnovtrfff")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value
     */
    @JvmName("sjljklkojmjsniif")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuSettingArgs = SkuSettingArgs(
        capabilities = capabilities,
        capacity = capacity,
        costs = costs,
        family = family,
        kind = kind,
        locationInfo = locationInfo,
        locations = locations,
        name = name ?: throw PulumiNullFieldException("name"),
        requiredFeatures = requiredFeatures,
        requiredQuotaIds = requiredQuotaIds,
        size = size,
        tier = tier,
    )
}
