@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property apiVersions
 * @property enabled
 * @property endpointType
 * @property extensions
 * @property featuresRule
 * @property locations
 * @property requiredFeatures
 * @property timeout
 */
public data class ResourceTypeEndpointResponse(
    public val apiVersions: List<String>? = null,
    public val enabled: Boolean? = null,
    public val endpointType: String? = null,
    public val extensions: List<ResourceTypeExtensionResponse>? = null,
    public val featuresRule: ResourceTypeEndpointResponseFeaturesRule? = null,
    public val locations: List<String>? = null,
    public val requiredFeatures: List<String>? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ResourceTypeEndpointResponse):
            ResourceTypeEndpointResponse = ResourceTypeEndpointResponse(
            apiVersions = javaType.apiVersions().map({ args0 -> args0 }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            featuresRule = javaType.featuresRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeEndpointResponseFeaturesRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            locations = javaType.locations().map({ args0 -> args0 }),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
