@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Identity Type
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.purview.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.purview.enums.Type> {
    None(com.pulumi.azurenative.purview.enums.Type.None),
    SystemAssigned(com.pulumi.azurenative.purview.enums.Type.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.purview.enums.Type.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.purview.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
