@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.GetKafkaConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the account.
 * @property kafkaConfigurationName Name of kafka configuration.
 * @property resourceGroupName The resource group name.
 */
public data class GetKafkaConfigurationPlainArgs(
    public val accountName: String,
    public val kafkaConfigurationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.GetKafkaConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.GetKafkaConfigurationPlainArgs =
        com.pulumi.azurenative.purview.inputs.GetKafkaConfigurationPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .kafkaConfigurationName(kafkaConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKafkaConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetKafkaConfigurationPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var kafkaConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("uwgdcjfhohmhehck")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Name of kafka configuration.
     */
    @JvmName("dnntqjubnpfkfcyo")
    public suspend fun kafkaConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kafkaConfigurationName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tfuhosyoprvgfwuq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKafkaConfigurationPlainArgs = GetKafkaConfigurationPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        kafkaConfigurationName = kafkaConfigurationName ?: throw
            PulumiNullFieldException("kafkaConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
