@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.purview.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The private link service connection state.
 * @property actionsRequired The required actions.
 * @property description The description.
 * @property status The status.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.purview.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    /**
     * @param value The required actions.
     */
    @JvmName("wcetddqpstpwrwki")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The description.
     */
    @JvmName("xrgeyngewcspmbwt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The status.
     */
    @JvmName("afxbyofppnnrurnv")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value The required actions.
     */
    @JvmName("yfhyuvpyrdftdkka")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The description.
     */
    @JvmName("atmwatpwkomsmjow")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The status.
     */
    @JvmName("thkcwqhiotjlyltj")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status.
     */
    @JvmName("bhigihhdnlhofesh")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status.
     */
    @JvmName("prrnhkyxvniqxoml")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
