@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the status of the account.
 * @property accountProvisioningState Gets the account status code.
 * @property errorDetails Gets the account error details.
 */
public data class AccountPropertiesResponseAccountStatus(
    public val accountProvisioningState: String,
    public val errorDetails: AccountStatusResponseErrorDetails,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.AccountPropertiesResponseAccountStatus):
            AccountPropertiesResponseAccountStatus = AccountPropertiesResponseAccountStatus(
            accountProvisioningState = javaType.accountProvisioningState(),
            errorDetails = javaType.errorDetails().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.AccountStatusResponseErrorDetails.Companion.toKotlin(args0)
            }),
        )
    }
}
