@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
 * @property consumerGroup Consumer group for hook event hub.
 * @property credentials Credentials to access event hub.
 * @property eventHubPartitionId Optional partition Id for notification event hub. If not set, all partitions will be leveraged.
 * @property eventHubResourceId
 * @property eventHubType The event hub type.
 * @property eventStreamingState The state of the event streaming service
 * @property eventStreamingType The event streaming service type
 * @property id Gets or sets the identifier.
 * @property name Gets or sets the name.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Gets or sets the type.
 */
public data class GetKafkaConfigurationResult(
    public val consumerGroup: String? = null,
    public val credentials: CredentialsResponse? = null,
    public val eventHubPartitionId: String? = null,
    public val eventHubResourceId: String? = null,
    public val eventHubType: String? = null,
    public val eventStreamingState: String? = null,
    public val eventStreamingType: String? = null,
    public val id: String,
    public val name: String,
    public val systemData: ProxyResourceResponseSystemData,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.GetKafkaConfigurationResult):
            GetKafkaConfigurationResult = GetKafkaConfigurationResult(
            consumerGroup = javaType.consumerGroup().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventHubPartitionId = javaType.eventHubPartitionId().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId().map({ args0 -> args0 }).orElse(null),
            eventHubType = javaType.eventHubType().map({ args0 -> args0 }).orElse(null),
            eventStreamingState = javaType.eventStreamingState().map({ args0 -> args0 }).orElse(null),
            eventStreamingType = javaType.eventStreamingType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
