@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata pertaining to creation and last modification of the resource.
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdBy The identity that created the resource.
 * @property createdByType The type of identity that created the resource.
 * @property lastModifiedAt The timestamp of the last modification the resource (UTC).
 * @property lastModifiedBy The identity that last modified the resource.
 * @property lastModifiedByType The type of identity that last modified the resource.
 */
public data class TrackedResourceResponseSystemData(
    public val createdAt: String,
    public val createdBy: String,
    public val createdByType: String,
    public val lastModifiedAt: String,
    public val lastModifiedBy: String,
    public val lastModifiedByType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.TrackedResourceResponseSystemData):
            TrackedResourceResponseSystemData = TrackedResourceResponseSystemData(
            createdAt = javaType.createdAt(),
            createdBy = javaType.createdBy(),
            createdByType = javaType.createdByType(),
            lastModifiedAt = javaType.lastModifiedAt(),
            lastModifiedBy = javaType.lastModifiedBy(),
            lastModifiedByType = javaType.lastModifiedByType(),
        )
    }
}
