@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin

import com.pulumi.azurenative.quantum.WorkspaceArgs.builder
import com.pulumi.azurenative.quantum.kotlin.inputs.ProviderArgs
import com.pulumi.azurenative.quantum.kotlin.inputs.ProviderArgsBuilder
import com.pulumi.azurenative.quantum.kotlin.inputs.QuantumWorkspaceIdentityArgs
import com.pulumi.azurenative.quantum.kotlin.inputs.QuantumWorkspaceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource proxy definition object for quantum workspace.
 * Azure REST API version: 2022-01-10-preview. Prior API version in Azure Native 1.x: 2019-11-04-preview.
 * Other available API versions: 2023-11-13-preview.
 * ## Example Usage
 * ### QuantumWorkspacesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Quantum.Workspace("workspace", new()
 *     {
 *         Location = "West US",
 *         Providers = new[]
 *         {
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "Honeywell",
 *                 ProviderSku = "Basic",
 *             },
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "IonQ",
 *                 ProviderSku = "Basic",
 *             },
 *             new AzureNative.Quantum.Inputs.ProviderArgs
 *             {
 *                 ProviderId = "OneQBit",
 *                 ProviderSku = "Basic",
 *             },
 *         },
 *         ResourceGroupName = "quantumResourcegroup",
 *         StorageAccount = "/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount",
 *         WorkspaceName = "quantumworkspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quantum/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quantum.NewWorkspace(ctx, "workspace", &quantum.WorkspaceArgs{
 * 			Location: pulumi.String("West US"),
 * 			Providers: quantum.ProviderArray{
 * 				&quantum.ProviderArgs{
 * 					ProviderId:  pulumi.String("Honeywell"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 				&quantum.ProviderArgs{
 * 					ProviderId:  pulumi.String("IonQ"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 				&quantum.ProviderArgs{
 * 					ProviderId:  pulumi.String("OneQBit"),
 * 					ProviderSku: pulumi.String("Basic"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("quantumResourcegroup"),
 * 			StorageAccount:    pulumi.String("/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
 * 			WorkspaceName:     pulumi.String("quantumworkspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quantum.Workspace;
 * import com.pulumi.azurenative.quantum.WorkspaceArgs;
 * import com.pulumi.azurenative.quantum.inputs.ProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("West US")
 *             .providers(
 *                 ProviderArgs.builder()
 *                     .providerId("Honeywell")
 *                     .providerSku("Basic")
 *                     .build(),
 *                 ProviderArgs.builder()
 *                     .providerId("IonQ")
 *                     .providerSku("Basic")
 *                     .build(),
 *                 ProviderArgs.builder()
 *                     .providerId("OneQBit")
 *                     .providerSku("Basic")
 *                     .build())
 *             .resourceGroupName("quantumResourcegroup")
 *             .storageAccount("/subscriptions/1C4B2828-7D49-494F-933D-061373BE28C2/resourceGroups/quantumResourcegroup/providers/Microsoft.Storage/storageAccounts/testStorageAccount")
 *             .workspaceName("quantumworkspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quantum:Workspace quantumworkspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Quantum/workspaces/{workspaceName}
 * ```
 * @property identity Managed Identity information.
 * @property location The geo-location where the resource lives
 * @property providers List of Providers selected for this Workspace
 * @property resourceGroupName The name of the resource group.
 * @property storageAccount ARM Resource Id of the storage account associated with this workspace.
 * @property tags Resource tags.
 * @property workspaceName The name of the quantum workspace resource.
 */
public data class WorkspaceArgs(
    public val identity: Output<QuantumWorkspaceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val providers: Output<List<ProviderArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccount: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quantum.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.quantum.WorkspaceArgs =
        com.pulumi.azurenative.quantum.WorkspaceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .providers(
                providers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var identity: Output<QuantumWorkspaceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var providers: Output<List<ProviderArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccount: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Managed Identity information.
     */
    @JvmName("oyeomxoipvuahied")
    public suspend fun identity(`value`: Output<QuantumWorkspaceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qcaiwgdmpvphtxgo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of Providers selected for this Workspace
     */
    @JvmName("etbknyjkcpyhkbub")
    public suspend fun providers(`value`: Output<List<ProviderArgs>>) {
        this.providers = value
    }

    @JvmName("ppkkjlemcarbssos")
    public suspend fun providers(vararg values: Output<ProviderArgs>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values List of Providers selected for this Workspace
     */
    @JvmName("cmjhkydffgljxken")
    public suspend fun providers(values: List<Output<ProviderArgs>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oltfmmsaqftapeph")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value ARM Resource Id of the storage account associated with this workspace.
     */
    @JvmName("ooutlxiyiqqpsblt")
    public suspend fun storageAccount(`value`: Output<String>) {
        this.storageAccount = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("flfsmyitvptqfdnl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the quantum workspace resource.
     */
    @JvmName("rijrnvoxajblaqlx")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Managed Identity information.
     */
    @JvmName("jinuxqvexcxvxtpt")
    public suspend fun identity(`value`: QuantumWorkspaceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed Identity information.
     */
    @JvmName("xfiwcgufiaxtusib")
    public suspend fun identity(argument: suspend QuantumWorkspaceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = QuantumWorkspaceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rlsydmdsoekqpdqb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of Providers selected for this Workspace
     */
    @JvmName("dplqkmqegxtiqxqm")
    public suspend fun providers(`value`: List<ProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param argument List of Providers selected for this Workspace
     */
    @JvmName("kklarrrohlfvwbak")
    public suspend fun providers(argument: List<suspend ProviderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ProviderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument List of Providers selected for this Workspace
     */
    @JvmName("kpgqpkbmvoyjwsxu")
    public suspend fun providers(vararg argument: suspend ProviderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ProviderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument List of Providers selected for this Workspace
     */
    @JvmName("maepmhfgcgdxqjbc")
    public suspend fun providers(argument: suspend ProviderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProviderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param values List of Providers selected for this Workspace
     */
    @JvmName("yprchcknpxcujsvs")
    public suspend fun providers(vararg values: ProviderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fneigmikpigbhnpj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value ARM Resource Id of the storage account associated with this workspace.
     */
    @JvmName("taqqragxsnhwsnfc")
    public suspend fun storageAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oajiwgnpfiuehaxa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cnkhkwnrmpsdnrjn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the quantum workspace resource.
     */
    @JvmName("pijtcgmofxmcnqgm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        identity = identity,
        location = location,
        providers = providers,
        resourceGroupName = resourceGroupName,
        storageAccount = storageAccount,
        tags = tags,
        workspaceName = workspaceName,
    )
}
