@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning status field
 */
public enum class Status(
    public val javaValue: com.pulumi.azurenative.quantum.enums.Status,
) : ConvertibleToJava<com.pulumi.azurenative.quantum.enums.Status> {
    Succeeded(com.pulumi.azurenative.quantum.enums.Status.Succeeded),
    Launching(com.pulumi.azurenative.quantum.enums.Status.Launching),
    Updating(com.pulumi.azurenative.quantum.enums.Status.Updating),
    Deleting(com.pulumi.azurenative.quantum.enums.Status.Deleting),
    Deleted(com.pulumi.azurenative.quantum.enums.Status.Deleted),
    Failed(com.pulumi.azurenative.quantum.enums.Status.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.quantum.enums.Status = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quantum.enums.Status): Status =
            Status.values().first { it.javaValue == javaType }
    }
}
