@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin

import com.pulumi.azurenative.quota.kotlin.outputs.GroupQuotasEntityBaseResponse
import com.pulumi.azurenative.quota.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.quota.kotlin.outputs.GroupQuotasEntityBaseResponse.Companion.toKotlin as groupQuotasEntityBaseResponseToKotlin
import com.pulumi.azurenative.quota.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GroupQuota].
 */
@PulumiTagMarker
public class GroupQuotaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupQuotaArgs = GroupQuotaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupQuotaArgsBuilder.() -> Unit) {
        val builder = GroupQuotaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupQuota {
        val builtJavaResource = com.pulumi.azurenative.quota.GroupQuota(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupQuota(builtJavaResource)
    }
}

/**
 * Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### GroupQuotas_Put_Request_ForCompute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupQuota = new AzureNative.Quota.GroupQuota("groupQuota", new()
 *     {
 *         GroupQuotaName = "groupquota1",
 *         ManagementGroupId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09",
 *         Properties = new AzureNative.Quota.Inputs.GroupQuotasEntityBaseArgs
 *         {
 *             AdditionalAttributes = new AzureNative.Quota.Inputs.AdditionalAttributesArgs
 *             {
 *                 Environment = "Production",
 *                 GroupId = new AzureNative.Quota.Inputs.GroupingIdArgs
 *                 {
 *                     GroupingIdType = AzureNative.Quota.GroupingIdType.ServiceTreeId,
 *                     Value = "yourServiceTreeIdHere",
 *                 },
 *             },
 *             DisplayName = "GroupQuota1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quota/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quota.NewGroupQuota(ctx, "groupQuota", &quota.GroupQuotaArgs{
 * 			GroupQuotaName:    pulumi.String("groupquota1"),
 * 			ManagementGroupId: pulumi.String("E7EC67B3-7657-4966-BFFC-41EFD36BAA09"),
 * 			Properties: &quota.GroupQuotasEntityBaseArgs{
 * 				AdditionalAttributes: &quota.AdditionalAttributesArgs{
 * 					Environment: pulumi.Any("Production"),
 * 					GroupId: &quota.GroupingIdArgs{
 * 						GroupingIdType: pulumi.String(quota.GroupingIdTypeServiceTreeId),
 * 						Value:          pulumi.String("yourServiceTreeIdHere"),
 * 					},
 * 				},
 * 				DisplayName: pulumi.String("GroupQuota1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quota.GroupQuota;
 * import com.pulumi.azurenative.quota.GroupQuotaArgs;
 * import com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs;
 * import com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs;
 * import com.pulumi.azurenative.quota.inputs.GroupingIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupQuota = new GroupQuota("groupQuota", GroupQuotaArgs.builder()
 *             .groupQuotaName("groupquota1")
 *             .managementGroupId("E7EC67B3-7657-4966-BFFC-41EFD36BAA09")
 *             .properties(GroupQuotasEntityBaseArgs.builder()
 *                 .additionalAttributes(AdditionalAttributesArgs.builder()
 *                     .environment("Production")
 *                     .groupId(GroupingIdArgs.builder()
 *                         .groupingIdType("ServiceTreeId")
 *                         .value("yourServiceTreeIdHere")
 *                         .build())
 *                     .build())
 *                 .displayName("GroupQuota1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quota:GroupQuota groupquota1 /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}
 * ```
 */
public class GroupQuota internal constructor(
    override val javaResource: com.pulumi.azurenative.quota.GroupQuota,
) : KotlinCustomResource(javaResource, GroupQuotaMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    public val properties: Output<GroupQuotasEntityBaseResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                groupQuotasEntityBaseResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GroupQuotaMapper : ResourceMapper<GroupQuota> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.quota.GroupQuota::class == javaResource::class

    override fun map(javaResource: Resource): GroupQuota = GroupQuota(
        javaResource as
            com.pulumi.azurenative.quota.GroupQuota,
    )
}

/**
 * @see [GroupQuota].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupQuota].
 */
public suspend fun groupQuota(name: String, block: suspend GroupQuotaResourceBuilder.() -> Unit):
    GroupQuota {
    val builder = GroupQuotaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupQuota].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupQuota(name: String): GroupQuota {
    val builder = GroupQuotaResourceBuilder()
    builder.name(name)
    return builder.build()
}
