@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.inputs

import com.pulumi.azurenative.quota.inputs.GroupingIdArgs.builder
import com.pulumi.azurenative.quota.kotlin.enums.GroupingIdType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The grouping Id for the group quota. It can be Billing Id or ServiceTreeId if applicable.
 * @property groupingIdType GroupingId type. It is a required property. More types of groupIds can be supported in future.
 * @property value GroupId value based on the groupingType selected - Billing Id or ServiceTreeId.
 */
public data class GroupingIdArgs(
    public val groupingIdType: Output<Either<String, GroupingIdType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quota.inputs.GroupingIdArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.inputs.GroupingIdArgs =
        com.pulumi.azurenative.quota.inputs.GroupingIdArgs.builder()
            .groupingIdType(
                groupingIdType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupingIdArgs].
 */
@PulumiTagMarker
public class GroupingIdArgsBuilder internal constructor() {
    private var groupingIdType: Output<Either<String, GroupingIdType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value GroupingId type. It is a required property. More types of groupIds can be supported in future.
     */
    @JvmName("ombddsdwjrfhmxwe")
    public suspend fun groupingIdType(`value`: Output<Either<String, GroupingIdType>>) {
        this.groupingIdType = value
    }

    /**
     * @param value GroupId value based on the groupingType selected - Billing Id or ServiceTreeId.
     */
    @JvmName("egopqqbporueehmh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value GroupingId type. It is a required property. More types of groupIds can be supported in future.
     */
    @JvmName("fntorcalcdrlifou")
    public suspend fun groupingIdType(`value`: Either<String, GroupingIdType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupingIdType = mapped
    }

    /**
     * @param value GroupingId type. It is a required property. More types of groupIds can be supported in future.
     */
    @JvmName("eeremndkaxbtnsoq")
    public fun groupingIdType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GroupingIdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupingIdType = mapped
    }

    /**
     * @param value GroupingId type. It is a required property. More types of groupIds can be supported in future.
     */
    @JvmName("fdogcjhtigegbwdd")
    public fun groupingIdType(`value`: GroupingIdType) {
        val toBeMapped = Either.ofRight<String, GroupingIdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupingIdType = mapped
    }

    /**
     * @param value GroupId value based on the groupingType selected - Billing Id or ServiceTreeId.
     */
    @JvmName("cavvluhvvrtgdewt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GroupingIdArgs = GroupingIdArgs(
        groupingIdType = groupingIdType,
        `value` = `value`,
    )
}
