@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This represents a Azure subscriptionId that is associated with a GroupQuotasEntity.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property properties
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGroupQuotaSubscriptionResult(
    public val id: String,
    public val name: String,
    public val properties: GroupQuotaSubscriptionIdResponseProperties,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.quota.outputs.GetGroupQuotaSubscriptionResult):
            GetGroupQuotaSubscriptionResult = GetGroupQuotaSubscriptionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.quota.kotlin.outputs.GroupQuotaSubscriptionIdResponseProperties.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.quota.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
