@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The grouping Id for the group quota. It can be Billing Id or ServiceTreeId if applicable.
 * @property groupingIdType GroupingId type. It is a required property. More types of groupIds can be supported in future.
 * @property value GroupId value based on the groupingType selected - Billing Id or ServiceTreeId.
 */
public data class GroupingIdResponse(
    public val groupingIdType: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quota.outputs.GroupingIdResponse):
            GroupingIdResponse = GroupingIdResponse(
            groupingIdType = javaType.groupingIdType().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
