@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.AccountArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.AccountResourcePropertiesArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.AccountResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Account resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update RecommendationsService Account resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.RecommendationsService.Account("account", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         Properties = new AzureNative.RecommendationsService.Inputs.AccountResourcePropertiesArgs
 *         {
 *             Configuration = AzureNative.RecommendationsService.AccountConfiguration.Capacity,
 *             EndpointAuthentications = new[]
 *             {
 *                 new AzureNative.RecommendationsService.Inputs.EndpointAuthenticationArgs
 *                 {
 *                     AadTenantID = "tenant",
 *                     PrincipalID = "oid",
 *                     PrincipalType = AzureNative.RecommendationsService.PrincipalType.User,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewAccount(ctx, "account", &recommendationsservice.AccountArgs{
 * 			AccountName: pulumi.String("sampleAccount"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: &recommendationsservice.AccountResourcePropertiesArgs{
 * 				Configuration: pulumi.String(recommendationsservice.AccountConfigurationCapacity),
 * 				EndpointAuthentications: recommendationsservice.EndpointAuthenticationArray{
 * 					&recommendationsservice.EndpointAuthenticationArgs{
 * 						AadTenantID:   pulumi.String("tenant"),
 * 						PrincipalID:   pulumi.String("oid"),
 * 						PrincipalType: pulumi.String(recommendationsservice.PrincipalTypeUser),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.Account;
 * import com.pulumi.azurenative.recommendationsservice.AccountArgs;
 * import com.pulumi.azurenative.recommendationsservice.inputs.AccountResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .properties(AccountResourcePropertiesArgs.builder()
 *                 .configuration("Capacity")
 *                 .endpointAuthentications(EndpointAuthenticationArgs.builder()
 *                     .aadTenantID("tenant")
 *                     .principalID("oid")
 *                     .principalType("User")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:Account sampleAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}
 * ```
 * @property accountName The name of the RecommendationsService Account resource.
 * @property location The geo-location where the resource lives
 * @property properties Account resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AccountResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.AccountArgs =
        com.pulumi.azurenative.recommendationsservice.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<AccountResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("kgvplmrkpesvqnwj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("evkdjqsojpoqrslp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Account resource properties.
     */
    @JvmName("naxiiwhiwhjkldtx")
    public suspend fun properties(`value`: Output<AccountResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wpcayimcdtdbiqnj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wpicwdqkawttumna")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the RecommendationsService Account resource.
     */
    @JvmName("slhovbbufwjbtoyu")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("snjultqdlwoliqeo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Account resource properties.
     */
    @JvmName("jqfcovuconxwovlp")
    public suspend fun properties(`value`: AccountResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Account resource properties.
     */
    @JvmName("cjvxjkqqigoncyym")
    public suspend fun properties(argument: suspend AccountResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhubfnlskofujtky")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eeuxijjlmchohrni")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("oqogxrvwebgnflbv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
