@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.ServiceEndpointResourceResponseProperties
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.ServiceEndpointResourceResponseProperties.Companion.toKotlin as serviceEndpointResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServiceEndpoint].
 */
@PulumiTagMarker
public class ServiceEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceEndpointArgs = ServiceEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceEndpointArgsBuilder.() -> Unit) {
        val builder = ServiceEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.recommendationsservice.ServiceEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceEndpoint(builtJavaResource)
    }
}

/**
 * ServiceEndpoint resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update ServiceEndpoint resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpoint = new AzureNative.RecommendationsService.ServiceEndpoint("serviceEndpoint", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         Properties = new AzureNative.RecommendationsService.Inputs.ServiceEndpointResourcePropertiesArgs
 *         {
 *             PreAllocatedCapacity = 100,
 *         },
 *         ResourceGroupName = "rg",
 *         ServiceEndpointName = "s1",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewServiceEndpoint(ctx, "serviceEndpoint", &recommendationsservice.ServiceEndpointArgs{
 * 			AccountName: pulumi.String("sampleAccount"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: &recommendationsservice.ServiceEndpointResourcePropertiesArgs{
 * 				PreAllocatedCapacity: pulumi.Int(100),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg"),
 * 			ServiceEndpointName: pulumi.String("s1"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.ServiceEndpoint;
 * import com.pulumi.azurenative.recommendationsservice.ServiceEndpointArgs;
 * import com.pulumi.azurenative.recommendationsservice.inputs.ServiceEndpointResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpoint = new ServiceEndpoint("serviceEndpoint", ServiceEndpointArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .properties(ServiceEndpointResourcePropertiesArgs.builder()
 *                 .preAllocatedCapacity(100)
 *                 .build())
 *             .resourceGroupName("rg")
 *             .serviceEndpointName("s1")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:ServiceEndpoint s1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}/serviceEndpoints/{serviceEndpointName}
 * ```
 */
public class ServiceEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.recommendationsservice.ServiceEndpoint,
) : KotlinCustomResource(javaResource, ServiceEndpointMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ServiceEndpoint resource properties.
     */
    public val properties: Output<ServiceEndpointResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceEndpointResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceEndpointMapper : ResourceMapper<ServiceEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recommendationsservice.ServiceEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ServiceEndpoint = ServiceEndpoint(
        javaResource as
            com.pulumi.azurenative.recommendationsservice.ServiceEndpoint,
    )
}

/**
 * @see [ServiceEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceEndpoint].
 */
public suspend fun serviceEndpoint(
    name: String,
    block: suspend ServiceEndpointResourceBuilder.() -> Unit,
): ServiceEndpoint {
    val builder = ServiceEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceEndpoint(name: String): ServiceEndpoint {
    val builder = ServiceEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
