@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.ModelingResourcePropertiesArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.enums.ModelingFeatures
import com.pulumi.azurenative.recommendationsservice.kotlin.enums.ModelingFrequency
import com.pulumi.azurenative.recommendationsservice.kotlin.enums.ModelingSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Modeling resource properties.
 * @property features Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
 * @property frequency Modeling frequency controls the modeling compute frequency.
 * @property inputData The configuration to raw CDM data to be used as Modeling resource input.
 * @property size Modeling size controls the maximum supported input data size.
 */
public data class ModelingResourcePropertiesArgs(
    public val features: Output<Either<String, ModelingFeatures>>? = null,
    public val frequency: Output<Either<String, ModelingFrequency>>? = null,
    public val inputData: Output<ModelingInputDataArgs>? = null,
    public val size: Output<Either<String, ModelingSize>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.ModelingResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recommendationsservice.inputs.ModelingResourcePropertiesArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.ModelingResourcePropertiesArgs.builder()
            .features(
                features?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputData(inputData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(
                size?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ModelingResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ModelingResourcePropertiesArgsBuilder internal constructor() {
    private var features: Output<Either<String, ModelingFeatures>>? = null

    private var frequency: Output<Either<String, ModelingFrequency>>? = null

    private var inputData: Output<ModelingInputDataArgs>? = null

    private var size: Output<Either<String, ModelingSize>>? = null

    /**
     * @param value Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
     */
    @JvmName("xynedlipbmsbsuub")
    public suspend fun features(`value`: Output<Either<String, ModelingFeatures>>) {
        this.features = value
    }

    /**
     * @param value Modeling frequency controls the modeling compute frequency.
     */
    @JvmName("gnodekfoehkxpksr")
    public suspend fun frequency(`value`: Output<Either<String, ModelingFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value The configuration to raw CDM data to be used as Modeling resource input.
     */
    @JvmName("fhnhassuknscccue")
    public suspend fun inputData(`value`: Output<ModelingInputDataArgs>) {
        this.inputData = value
    }

    /**
     * @param value Modeling size controls the maximum supported input data size.
     */
    @JvmName("dprvkhwluipaekvq")
    public suspend fun size(`value`: Output<Either<String, ModelingSize>>) {
        this.size = value
    }

    /**
     * @param value Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
     */
    @JvmName("jxgeemackdcbpxtj")
    public suspend fun features(`value`: Either<String, ModelingFeatures>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
     */
    @JvmName("deopcosydsxhtnrn")
    public fun features(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ModelingFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value Modeling features controls the set of supported scenarios\models being computed. This can only be set at Modeling creation.
     */
    @JvmName("egmtgerfwgmlqsqn")
    public fun features(`value`: ModelingFeatures) {
        val toBeMapped = Either.ofRight<String, ModelingFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value Modeling frequency controls the modeling compute frequency.
     */
    @JvmName("iuyeavfekesyptuf")
    public suspend fun frequency(`value`: Either<String, ModelingFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Modeling frequency controls the modeling compute frequency.
     */
    @JvmName("mamarrhbysxlyatt")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ModelingFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Modeling frequency controls the modeling compute frequency.
     */
    @JvmName("ysccawyuuxhbdmpn")
    public fun frequency(`value`: ModelingFrequency) {
        val toBeMapped = Either.ofRight<String, ModelingFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The configuration to raw CDM data to be used as Modeling resource input.
     */
    @JvmName("dpqyhnwnrrblgodb")
    public suspend fun inputData(`value`: ModelingInputDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputData = mapped
    }

    /**
     * @param argument The configuration to raw CDM data to be used as Modeling resource input.
     */
    @JvmName("iebewpfnalxhnvfj")
    public suspend fun inputData(argument: suspend ModelingInputDataArgsBuilder.() -> Unit) {
        val toBeMapped = ModelingInputDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputData = mapped
    }

    /**
     * @param value Modeling size controls the maximum supported input data size.
     */
    @JvmName("fwhgflhnqklnxrmf")
    public suspend fun size(`value`: Either<String, ModelingSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Modeling size controls the maximum supported input data size.
     */
    @JvmName("ywyqonhhgwaqssxh")
    public fun size(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ModelingSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Modeling size controls the maximum supported input data size.
     */
    @JvmName("sjopmmsbttpqonrg")
    public fun size(`value`: ModelingSize) {
        val toBeMapped = Either.ofRight<String, ModelingSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): ModelingResourcePropertiesArgs = ModelingResourcePropertiesArgs(
        features = features,
        frequency = frequency,
        inputData = inputData,
        size = size,
    )
}
