@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.ServiceEndpointResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ServiceEndpoint resource properties.
 * @property preAllocatedCapacity ServiceEndpoint pre-allocated capacity controls the maximum requests-per-second allowed for that endpoint. Only applicable when Account configuration is Capacity.
 */
public data class ServiceEndpointResourcePropertiesArgs(
    public val preAllocatedCapacity: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.ServiceEndpointResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recommendationsservice.inputs.ServiceEndpointResourcePropertiesArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.ServiceEndpointResourcePropertiesArgs.builder()
            .preAllocatedCapacity(preAllocatedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEndpointResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ServiceEndpointResourcePropertiesArgsBuilder internal constructor() {
    private var preAllocatedCapacity: Output<Int>? = null

    /**
     * @param value ServiceEndpoint pre-allocated capacity controls the maximum requests-per-second allowed for that endpoint. Only applicable when Account configuration is Capacity.
     */
    @JvmName("dihtsslbnjsprcgi")
    public suspend fun preAllocatedCapacity(`value`: Output<Int>) {
        this.preAllocatedCapacity = value
    }

    /**
     * @param value ServiceEndpoint pre-allocated capacity controls the maximum requests-per-second allowed for that endpoint. Only applicable when Account configuration is Capacity.
     */
    @JvmName("jeuqffkhjsnddooq")
    public suspend fun preAllocatedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preAllocatedCapacity = mapped
    }

    internal fun build(): ServiceEndpointResourcePropertiesArgs =
        ServiceEndpointResourcePropertiesArgs(
            preAllocatedCapacity = preAllocatedCapacity,
        )
}
