@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProtectedItem].
 */
@PulumiTagMarker
public class ProtectedItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectedItemArgs = ProtectedItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectedItemArgsBuilder.() -> Unit) {
        val builder = ProtectedItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProtectedItem {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ProtectedItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectedItem(builtJavaResource)
    }
}

/**
 * Base class for backup items.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2016-06-01, 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Enable Protection on Azure IaasVm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.RecoveryServices.ProtectedItem("protectedItem", new()
 *     {
 *         ContainerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSComputeVMProtectedItemArgs
 *         {
 *             PolicyId = "/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy",
 *             ProtectedItemType = "Microsoft.Compute/virtualMachines",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 *         },
 *         ProtectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectedItem(ctx, "protectedItem", &recoveryservices.ProtectedItemArgs{
 * 			ContainerName: pulumi.String("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureIaaSComputeVMProtectedItem{
 * 				PolicyId:          "/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy",
 * 				ProtectedItemType: "Microsoft.Compute/virtualMachines",
 * 				SourceResourceId:  "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 * 			},
 * 			ProtectedItemName: pulumi.String("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .containerName("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .fabricName("Azure")
 *             .properties(AzureFileshareProtectedItemArgs.builder()
 *                 .policyId("/Subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/SwaggerTestRg/providers/Microsoft.RecoveryServices/vaults/NetSDKTestRsVault/backupPolicies/DefaultPolicy")
 *                 .protectedItemType("Microsoft.Compute/virtualMachines")
 *                 .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1")
 *                 .build())
 *             .protectedItemName("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Stop Protection with retain data on Azure IaasVm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.RecoveryServices.ProtectedItem("protectedItem", new()
 *     {
 *         ContainerName = "IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSComputeVMProtectedItemArgs
 *         {
 *             ProtectedItemType = "Microsoft.Compute/virtualMachines",
 *             ProtectionState = AzureNative.RecoveryServices.ProtectionState.ProtectionStopped,
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 *         },
 *         ProtectedItemName = "VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1",
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectedItem(ctx, "protectedItem", &recoveryservices.ProtectedItemArgs{
 * 			ContainerName: pulumi.String("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureIaaSComputeVMProtectedItem{
 * 				ProtectedItemType: "Microsoft.Compute/virtualMachines",
 * 				ProtectionState:   recoveryservices.ProtectionStateProtectionStopped,
 * 				SourceResourceId:  "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1",
 * 			},
 * 			ProtectedItemName: pulumi.String("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ProtectedItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .containerName("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .fabricName("Azure")
 *             .properties(AzureFileshareProtectedItemArgs.builder()
 *                 .protectedItemType("Microsoft.Compute/virtualMachines")
 *                 .protectionState("ProtectionStopped")
 *                 .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/netsdktestrg/providers/Microsoft.Compute/virtualMachines/netvmtestv2vm1")
 *                 .build())
 *             .protectedItemName("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1")
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectedItem VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}
 * ```
 */
public class ProtectedItem internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ProtectedItem,
) : KotlinCustomResource(javaResource, ProtectedItemMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ProtectedItemResource properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProtectedItemMapper : ResourceMapper<ProtectedItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ProtectedItem::class == javaResource::class

    override fun map(javaResource: Resource): ProtectedItem = ProtectedItem(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ProtectedItem,
    )
}

/**
 * @see [ProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectedItem].
 */
public suspend fun protectedItem(
    name: String,
    block: suspend ProtectedItemResourceBuilder.() -> Unit,
): ProtectedItem {
    val builder = ProtectedItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectedItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectedItem(name: String): ProtectedItem {
    val builder = ProtectedItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
