@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.EnableMigrationInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.EnableMigrationInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Migration item.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Enables migration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationMigrationItem = new AzureNative.RecoveryServices.ReplicationMigrationItem("replicationMigrationItem", new()
 *     {
 *         FabricName = "vmwarefabric1",
 *         MigrationItemName = "virtualmachine1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.EnableMigrationInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1",
 *             ProviderSpecificDetails = new AzureNative.RecoveryServices.Inputs.VMwareCbtEnableMigrationInputArgs
 *             {
 *                 DataMoverRunAsAccountId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1",
 *                 DisksToInclude = new[]
 *                 {
 *                     new AzureNative.RecoveryServices.Inputs.VMwareCbtDiskInputArgs
 *                     {
 *                         DiskId = "disk1",
 *                         IsOSDisk = "true",
 *                         LogStorageAccountId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1",
 *                         LogStorageAccountSasSecretName = "logStorageSas",
 *                     },
 *                 },
 *                 InstanceType = "VMwareCbt",
 *                 SnapshotRunAsAccountId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1",
 *                 TargetNetworkId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1",
 *                 TargetResourceGroupId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1",
 *                 VmwareMachineId = "/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1",
 *             },
 *         },
 *         ProtectionContainerName = "vmwareContainer1",
 *         ResourceGroupName = "resourcegroup1",
 *         ResourceName = "migrationvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationMigrationItem(ctx, "replicationMigrationItem", &recoveryservices.ReplicationMigrationItemArgs{
 * FabricName: pulumi.String("vmwarefabric1"),
 * MigrationItemName: pulumi.String("virtualmachine1"),
 * Properties: &recoveryservices.EnableMigrationInputPropertiesArgs{
 * PolicyId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1"),
 * ProviderSpecificDetails: interface{}{
 * DataMoverRunAsAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1"),
 * DisksToInclude: recoveryservices.VMwareCbtDiskInputArray{
 * &recoveryservices.VMwareCbtDiskInputArgs{
 * DiskId: pulumi.String("disk1"),
 * IsOSDisk: pulumi.String("true"),
 * LogStorageAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1"),
 * LogStorageAccountSasSecretName: pulumi.String("logStorageSas"),
 * },
 * },
 * InstanceType: pulumi.String("VMwareCbt"),
 * SnapshotRunAsAccountId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1"),
 * TargetNetworkId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1"),
 * TargetResourceGroupId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1"),
 * VmwareMachineId: pulumi.String("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1"),
 * },
 * },
 * ProtectionContainerName: pulumi.String("vmwareContainer1"),
 * ResourceGroupName: pulumi.String("resourcegroup1"),
 * ResourceName: pulumi.String("migrationvault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationMigrationItem;
 * import com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.EnableMigrationInputPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtEnableMigrationInputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationMigrationItem = new ReplicationMigrationItem("replicationMigrationItem", ReplicationMigrationItemArgs.builder()
 *             .fabricName("vmwarefabric1")
 *             .migrationItemName("virtualmachine1")
 *             .properties(EnableMigrationInputPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.RecoveryServices/vaults/migrationvault/replicationPolicies/vmwarepolicy1")
 *                 .providerSpecificDetails(VMwareCbtEnableMigrationInputArgs.builder()
 *                     .dataMoverRunAsAccountId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/dataMoverRunAsAccount1")
 *                     .disksToInclude(VMwareCbtDiskInputArgs.builder()
 *                         .diskId("disk1")
 *                         .isOSDisk("true")
 *                         .logStorageAccountId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Storage/storageAccounts/logStorageAccount1")
 *                         .logStorageAccountSasSecretName("logStorageSas")
 *                         .build())
 *                     .instanceType("VMwareCbt")
 *                     .snapshotRunAsAccountId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/runasaccounts/snapshotRunAsAccount1")
 *                     .targetNetworkId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.Network/virtualNetworks/virtualNetwork1")
 *                     .targetResourceGroupId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1")
 *                     .vmwareMachineId("/Subscriptions/cb53d0c3-bd59-4721-89bc-06916a9147ef/resourceGroups/resourcegroup1/providers/Microsoft.OffAzure/VMwareSites/vmwaresite1/machines/virtualmachine1")
 *                     .build())
 *                 .build())
 *             .protectionContainerName("vmwareContainer1")
 *             .resourceGroupName("resourcegroup1")
 *             .resourceName("migrationvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationMigrationItem virtualmachine1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}
 * ```
 * @property fabricName Fabric name.
 * @property migrationItemName Migration item name.
 * @property properties Enable migration input properties.
 * @property protectionContainerName Protection container name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationMigrationItemArgs(
    public val fabricName: Output<String>? = null,
    public val migrationItemName: Output<String>? = null,
    public val properties: Output<EnableMigrationInputPropertiesArgs>? = null,
    public val protectionContainerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationMigrationItemArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .migrationItemName(migrationItemName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectionContainerName(protectionContainerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationMigrationItemArgs].
 */
@PulumiTagMarker
public class ReplicationMigrationItemArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var migrationItemName: Output<String>? = null

    private var properties: Output<EnableMigrationInputPropertiesArgs>? = null

    private var protectionContainerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("nfbbgeaiiktxdjix")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Migration item name.
     */
    @JvmName("kytahkhvidwcxfss")
    public suspend fun migrationItemName(`value`: Output<String>) {
        this.migrationItemName = value
    }

    /**
     * @param value Enable migration input properties.
     */
    @JvmName("gvxwxwkshpahelwc")
    public suspend fun properties(`value`: Output<EnableMigrationInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("stwaxhjyvrvutxpq")
    public suspend fun protectionContainerName(`value`: Output<String>) {
        this.protectionContainerName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("jbbbfvbyrhkyaumx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("gmefmlrihiecmcjj")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("kpwjsfrwjubkiomn")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Migration item name.
     */
    @JvmName("mybycckvfgrnauvw")
    public suspend fun migrationItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationItemName = mapped
    }

    /**
     * @param value Enable migration input properties.
     */
    @JvmName("rsdoqhhmieccrbci")
    public suspend fun properties(`value`: EnableMigrationInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Enable migration input properties.
     */
    @JvmName("segxuujherkhpwax")
    public suspend
    fun properties(argument: suspend EnableMigrationInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnableMigrationInputPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("jmraycbcvndcbhoh")
    public suspend fun protectionContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionContainerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("fiidsxyfqbxktadp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("nfeneryxtfkwodne")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationMigrationItemArgs = ReplicationMigrationItemArgs(
        fabricName = fabricName,
        migrationItemName = migrationItemName,
        properties = properties,
        protectionContainerName = protectionContainerName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
