@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.NetworkMappingPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.NetworkMappingPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationNetworkMapping].
 */
@PulumiTagMarker
public class ReplicationNetworkMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationNetworkMappingArgs = ReplicationNetworkMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationNetworkMappingArgsBuilder.() -> Unit) {
        val builder = ReplicationNetworkMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationNetworkMapping {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationNetworkMapping(builtJavaResource)
    }
}

/**
 * Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2021-03-01, 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Creates network mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationNetworkMapping = new AzureNative.RecoveryServices.ReplicationNetworkMapping("replicationNetworkMapping", new()
 *     {
 *         FabricName = "b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac",
 *         NetworkMappingName = "corpe2amap",
 *         NetworkName = "e2267b5c-2650-49bd-ab3f-d66aae694c06",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateNetworkMappingInputPropertiesArgs
 *         {
 *             FabricSpecificDetails = new AzureNative.RecoveryServices.Inputs.VmmToAzureCreateNetworkMappingInputArgs
 *             {
 *                 InstanceType = "VmmToAzure",
 *             },
 *             RecoveryFabricName = "Microsoft Azure",
 *             RecoveryNetworkId = "/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai",
 *         },
 *         ResourceGroupName = "srcBvte2a14C27",
 *         ResourceName = "srce2avaultbvtaC27",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationNetworkMapping(ctx, "replicationNetworkMapping", &recoveryservices.ReplicationNetworkMappingArgs{
 * 			FabricName:         pulumi.String("b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac"),
 * 			NetworkMappingName: pulumi.String("corpe2amap"),
 * 			NetworkName:        pulumi.String("e2267b5c-2650-49bd-ab3f-d66aae694c06"),
 * 			Properties: &recoveryservices.CreateNetworkMappingInputPropertiesArgs{
 * 				FabricSpecificDetails: recoveryservices.VmmToAzureCreateNetworkMappingInput{
 * 					InstanceType: "VmmToAzure",
 * 				},
 * 				RecoveryFabricName: pulumi.String("Microsoft Azure"),
 * 				RecoveryNetworkId:  pulumi.String("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai"),
 * 			},
 * 			ResourceGroupName: pulumi.String("srcBvte2a14C27"),
 * 			ResourceName:      pulumi.String("srce2avaultbvtaC27"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationNetworkMapping = new ReplicationNetworkMapping("replicationNetworkMapping", ReplicationNetworkMappingArgs.builder()
 *             .fabricName("b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac")
 *             .networkMappingName("corpe2amap")
 *             .networkName("e2267b5c-2650-49bd-ab3f-d66aae694c06")
 *             .properties(CreateNetworkMappingInputPropertiesArgs.builder()
 *                 .fabricSpecificDetails(VmmToAzureCreateNetworkMappingInputArgs.builder()
 *                     .instanceType("VmmToAzure")
 *                     .build())
 *                 .recoveryFabricName("Microsoft Azure")
 *                 .recoveryNetworkId("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai")
 *                 .build())
 *             .resourceGroupName("srcBvte2a14C27")
 *             .resourceName("srce2avaultbvtaC27")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationNetworkMapping corpe2amap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}
 * ```
 */
public class ReplicationNetworkMapping internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping,
) : KotlinCustomResource(javaResource, ReplicationNetworkMappingMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Network Mapping Properties.
     */
    public val properties: Output<NetworkMappingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationNetworkMappingMapper : ResourceMapper<ReplicationNetworkMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationNetworkMapping =
        ReplicationNetworkMapping(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping,
        )
}

/**
 * @see [ReplicationNetworkMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationNetworkMapping].
 */
public suspend fun replicationNetworkMapping(
    name: String,
    block: suspend ReplicationNetworkMappingResourceBuilder.() -> Unit,
): ReplicationNetworkMapping {
    val builder = ReplicationNetworkMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationNetworkMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationNetworkMapping(name: String): ReplicationNetworkMapping {
    val builder = ReplicationNetworkMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
