@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreatePolicyInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreatePolicyInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Protection profile details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Creates the policy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationPolicy = new AzureNative.RecoveryServices.ReplicationPolicy("replicationPolicy", new()
 *     {
 *         PolicyName = "protectionprofile1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreatePolicyInputPropertiesArgs
 *         {
 *             ProviderSpecificInput = new AzureNative.RecoveryServices.Inputs.HyperVReplicaAzurePolicyInputArgs
 *             {
 *                 InstanceType = "HyperVReplicaAzure",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationPolicy(ctx, "replicationPolicy", &recoveryservices.ReplicationPolicyArgs{
 * 			PolicyName: pulumi.String("protectionprofile1"),
 * 			Properties: &recoveryservices.CreatePolicyInputPropertiesArgs{
 * 				ProviderSpecificInput: recoveryservices.HyperVReplicaAzurePolicyInput{
 * 					InstanceType: "HyperVReplicaAzure",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * 			ResourceName:      pulumi.String("vault1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationPolicy;
 * import com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.CreatePolicyInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationPolicy = new ReplicationPolicy("replicationPolicy", ReplicationPolicyArgs.builder()
 *             .policyName("protectionprofile1")
 *             .properties(CreatePolicyInputPropertiesArgs.builder()
 *                 .providerSpecificInput(HyperVReplicaAzurePolicyInputArgs.builder()
 *                     .instanceType("HyperVReplicaAzure")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationPolicy protectionprofile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}
 * ```
 * @property policyName Replication policy name.
 * @property properties Policy creation properties.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationPolicyArgs(
    public val policyName: Output<String>? = null,
    public val properties: Output<CreatePolicyInputPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationPolicyArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationPolicyArgs].
 */
@PulumiTagMarker
public class ReplicationPolicyArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var properties: Output<CreatePolicyInputPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Replication policy name.
     */
    @JvmName("ldvjxpaqbkmpskwu")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Policy creation properties.
     */
    @JvmName("blxuapewanpyiocm")
    public suspend fun properties(`value`: Output<CreatePolicyInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("aobarspfasnyifoa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("qaaomgnnjljpvoxr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Replication policy name.
     */
    @JvmName("ybrvlcrygsggdreh")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Policy creation properties.
     */
    @JvmName("ypiscpyxhltcjevf")
    public suspend fun properties(`value`: CreatePolicyInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Policy creation properties.
     */
    @JvmName("imyuvpceqtirnkcq")
    public suspend
    fun properties(argument: suspend CreatePolicyInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreatePolicyInputPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("jjfgcqnernvlipeh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("dcjqbfotongnhpps")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationPolicyArgs = ReplicationPolicyArgs(
        policyName = policyName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
