@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.EnableProtectionInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.EnableProtectionInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Replication protected item.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Enables protection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectedItem = new AzureNative.RecoveryServices.ReplicationProtectedItem("replicationProtectedItem", new()
 *     {
 *         FabricName = "cloud1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.EnableProtectionInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1",
 *             ProtectableItemId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b",
 *             ProviderSpecificDetails = new AzureNative.RecoveryServices.Inputs.HyperVReplicaAzureEnableProtectionInputArgs
 *             {
 *                 InstanceType = "HyperVReplicaAzure",
 *             },
 *         },
 *         ProtectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179",
 *         ReplicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationProtectedItem(ctx, "replicationProtectedItem", &recoveryservices.ReplicationProtectedItemArgs{
 * 			FabricName: pulumi.String("cloud1"),
 * 			Properties: &recoveryservices.EnableProtectionInputPropertiesArgs{
 * 				PolicyId:          pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1"),
 * 				ProtectableItemId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 				ProviderSpecificDetails: recoveryservices.HyperVReplicaAzureEnableProtectionInput{
 * 					InstanceType: "HyperVReplicaAzure",
 * 				},
 * 			},
 * 			ProtectionContainerName:     pulumi.String("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
 * 			ReplicatedProtectedItemName: pulumi.String("f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 			ResourceGroupName:           pulumi.String("resourceGroupPS1"),
 * 			ResourceName:                pulumi.String("vault1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectedItem;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.EnableProtectionInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectedItem = new ReplicationProtectedItem("replicationProtectedItem", ReplicationProtectedItemArgs.builder()
 *             .fabricName("cloud1")
 *             .properties(EnableProtectionInputPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1")
 *                 .protectableItemId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectableItems/f8491e4f-817a-40dd-a90c-af773978c75b")
 *                 .providerSpecificDetails(HyperVReplicaAzureEnableProtectionInputArgs.builder()
 *                     .instanceType("HyperVReplicaAzure")
 *                     .build())
 *                 .build())
 *             .protectionContainerName("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179")
 *             .replicatedProtectedItemName("f8491e4f-817a-40dd-a90c-af773978c75b")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectedItem f8491e4f-817a-40dd-a90c-af773978c75b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}
 * ```
 * @property fabricName Name of the fabric.
 * @property properties Enable protection input properties.
 * @property protectionContainerName Protection container name.
 * @property replicatedProtectedItemName A name for the replication protected item.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationProtectedItemArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<EnableProtectionInputPropertiesArgs>? = null,
    public val protectionContainerName: Output<String>? = null,
    public val replicatedProtectedItemName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectedItemArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectionContainerName(protectionContainerName?.applyValue({ args0 -> args0 }))
            .replicatedProtectedItemName(replicatedProtectedItemName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationProtectedItemArgs].
 */
@PulumiTagMarker
public class ReplicationProtectedItemArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<EnableProtectionInputPropertiesArgs>? = null

    private var protectionContainerName: Output<String>? = null

    private var replicatedProtectedItemName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Name of the fabric.
     */
    @JvmName("rmwlfyrquewsujhx")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Enable protection input properties.
     */
    @JvmName("oesgnxrwrqkwflnj")
    public suspend fun properties(`value`: Output<EnableProtectionInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("hxrbufpeexphhuqp")
    public suspend fun protectionContainerName(`value`: Output<String>) {
        this.protectionContainerName = value
    }

    /**
     * @param value A name for the replication protected item.
     */
    @JvmName("yvdjtrqkvxmncxvm")
    public suspend fun replicatedProtectedItemName(`value`: Output<String>) {
        this.replicatedProtectedItemName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("drileptjarasvvnh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("wgpriijaudvxjjra")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Name of the fabric.
     */
    @JvmName("xwgvdwxxbxrypgva")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Enable protection input properties.
     */
    @JvmName("pkqrinhqfbwhrehr")
    public suspend fun properties(`value`: EnableProtectionInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Enable protection input properties.
     */
    @JvmName("gpqmsurakbtmqglv")
    public suspend
    fun properties(argument: suspend EnableProtectionInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnableProtectionInputPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("xcmkxolmdoqsibpm")
    public suspend fun protectionContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionContainerName = mapped
    }

    /**
     * @param value A name for the replication protected item.
     */
    @JvmName("lbemsrjfbmpgqaud")
    public suspend fun replicatedProtectedItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicatedProtectedItemName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("ugrdfwlvflawxuay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("rkmjnsigtdvtccdb")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationProtectedItemArgs = ReplicationProtectedItemArgs(
        fabricName = fabricName,
        properties = properties,
        protectionContainerName = protectionContainerName,
        replicatedProtectedItemName = replicatedProtectedItemName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
