@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ProtectionContainerMappingPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ProtectionContainerMappingPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationProtectionContainerMapping].
 */
@PulumiTagMarker
public class ReplicationProtectionContainerMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationProtectionContainerMappingArgs =
        ReplicationProtectionContainerMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ReplicationProtectionContainerMappingArgsBuilder.() -> Unit) {
        val builder = ReplicationProtectionContainerMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationProtectionContainerMapping {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationProtectionContainerMapping(builtJavaResource)
    }
}

/**
 * Protection container mapping object.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Create protection container mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectionContainerMapping = new AzureNative.RecoveryServices.ReplicationProtectionContainerMapping("replicationProtectionContainerMapping", new()
 *     {
 *         FabricName = "cloud1",
 *         MappingName = "cloud1protectionprofile1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateProtectionContainerMappingInputPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1",
 *             ProviderSpecificInput =
 *             {
 *                 { "instanceType", "ReplicationProviderSpecificContainerMappingInput" },
 *             },
 *             TargetProtectionContainerId = "Microsoft Azure",
 *         },
 *         ProtectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationProtectionContainerMapping(ctx, "replicationProtectionContainerMapping", &recoveryservices.ReplicationProtectionContainerMappingArgs{
 * FabricName: pulumi.String("cloud1"),
 * MappingName: pulumi.String("cloud1protectionprofile1"),
 * Properties: &recoveryservices.CreateProtectionContainerMappingInputPropertiesArgs{
 * PolicyId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1"),
 * ProviderSpecificInput: interface{}{
 * InstanceType: pulumi.String("ReplicationProviderSpecificContainerMappingInput"),
 * },
 * TargetProtectionContainerId: pulumi.String("Microsoft Azure"),
 * },
 * ProtectionContainerName: pulumi.String("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMappingArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.CreateProtectionContainerMappingInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectionContainerMapping = new ReplicationProtectionContainerMapping("replicationProtectionContainerMapping", ReplicationProtectionContainerMappingArgs.builder()
 *             .fabricName("cloud1")
 *             .mappingName("cloud1protectionprofile1")
 *             .properties(CreateProtectionContainerMappingInputPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/protectionprofile1")
 *                 .providerSpecificInput(A2AContainerMappingInputArgs.builder()
 *                     .instanceType("ReplicationProviderSpecificContainerMappingInput")
 *                     .build())
 *                 .targetProtectionContainerId("Microsoft Azure")
 *                 .build())
 *             .protectionContainerName("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectionContainerMapping cloud1protectionprofile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}
 * ```
 */
public class ReplicationProtectionContainerMapping internal constructor(
    override val javaResource:
    com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping,
) : KotlinCustomResource(javaResource, ReplicationProtectionContainerMappingMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The custom data.
     */
    public val properties: Output<ProtectionContainerMappingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationProtectionContainerMappingMapper :
    ResourceMapper<ReplicationProtectionContainerMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationProtectionContainerMapping =
        ReplicationProtectionContainerMapping(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationProtectionContainerMapping,
        )
}

/**
 * @see [ReplicationProtectionContainerMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationProtectionContainerMapping].
 */
public suspend fun replicationProtectionContainerMapping(
    name: String,
    block: suspend ReplicationProtectionContainerMappingResourceBuilder.() -> Unit,
):
    ReplicationProtectionContainerMapping {
    val builder = ReplicationProtectionContainerMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationProtectionContainerMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationProtectionContainerMapping(name: String):
    ReplicationProtectionContainerMapping {
    val builder = ReplicationProtectionContainerMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
