@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.AddRecoveryServicesProviderInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.AddRecoveryServicesProviderInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provider details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01.
 * ## Example Usage
 * ### Adds a recovery services provider.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationRecoveryServicesProvider = new AzureNative.RecoveryServices.ReplicationRecoveryServicesProvider("replicationRecoveryServicesProvider", new()
 *     {
 *         FabricName = "vmwarefabric1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AddRecoveryServicesProviderInputPropertiesArgs
 *         {
 *             AuthenticationIdentityInput = new AzureNative.RecoveryServices.Inputs.IdentityProviderInputArgs
 *             {
 *                 AadAuthority = "https://login.microsoftonline.com",
 *                 ApplicationId = "f66fce08-c0c6-47a1-beeb-0ede5ea94f90",
 *                 Audience = "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874",
 *                 ObjectId = "141360b8-5686-4240-a027-5e24e6affeba",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             MachineName = "vmwareprovider1",
 *             ResourceAccessIdentityInput = new AzureNative.RecoveryServices.Inputs.IdentityProviderInputArgs
 *             {
 *                 AadAuthority = "https://login.microsoftonline.com",
 *                 ApplicationId = "f66fce08-c0c6-47a1-beeb-0ede5ea94f90",
 *                 Audience = "https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874",
 *                 ObjectId = "141360b8-5686-4240-a027-5e24e6affeba",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ProviderName = "vmwareprovider1",
 *         ResourceGroupName = "resourcegroup1",
 *         ResourceName = "migrationvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationRecoveryServicesProvider(ctx, "replicationRecoveryServicesProvider", &recoveryservices.ReplicationRecoveryServicesProviderArgs{
 * 			FabricName: pulumi.String("vmwarefabric1"),
 * 			Properties: &recoveryservices.AddRecoveryServicesProviderInputPropertiesArgs{
 * 				AuthenticationIdentityInput: &recoveryservices.IdentityProviderInputArgs{
 * 					AadAuthority:  pulumi.String("https://login.microsoftonline.com"),
 * 					ApplicationId: pulumi.String("f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 * 					Audience:      pulumi.String("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 * 					ObjectId:      pulumi.String("141360b8-5686-4240-a027-5e24e6affeba"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				MachineName: pulumi.String("vmwareprovider1"),
 * 				ResourceAccessIdentityInput: &recoveryservices.IdentityProviderInputArgs{
 * 					AadAuthority:  pulumi.String("https://login.microsoftonline.com"),
 * 					ApplicationId: pulumi.String("f66fce08-c0c6-47a1-beeb-0ede5ea94f90"),
 * 					Audience:      pulumi.String("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874"),
 * 					ObjectId:      pulumi.String("141360b8-5686-4240-a027-5e24e6affeba"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ProviderName:      pulumi.String("vmwareprovider1"),
 * 			ResourceGroupName: pulumi.String("resourcegroup1"),
 * 			ResourceName:      pulumi.String("migrationvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProvider;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.AddRecoveryServicesProviderInputPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.IdentityProviderInputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationRecoveryServicesProvider = new ReplicationRecoveryServicesProvider("replicationRecoveryServicesProvider", ReplicationRecoveryServicesProviderArgs.builder()
 *             .fabricName("vmwarefabric1")
 *             .properties(AddRecoveryServicesProviderInputPropertiesArgs.builder()
 *                 .authenticationIdentityInput(IdentityProviderInputArgs.builder()
 *                     .aadAuthority("https://login.microsoftonline.com")
 *                     .applicationId("f66fce08-c0c6-47a1-beeb-0ede5ea94f90")
 *                     .audience("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874")
 *                     .objectId("141360b8-5686-4240-a027-5e24e6affeba")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .machineName("vmwareprovider1")
 *                 .resourceAccessIdentityInput(IdentityProviderInputArgs.builder()
 *                     .aadAuthority("https://login.microsoftonline.com")
 *                     .applicationId("f66fce08-c0c6-47a1-beeb-0ede5ea94f90")
 *                     .audience("https://microsoft.onmicrosoft.com/cf19e349-644c-4c6a-bcae-9c8f35357874")
 *                     .objectId("141360b8-5686-4240-a027-5e24e6affeba")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .build())
 *             .providerName("vmwareprovider1")
 *             .resourceGroupName("resourcegroup1")
 *             .resourceName("migrationvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationRecoveryServicesProvider vmwareprovider1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}
 * ```
 * @property fabricName Fabric name.
 * @property properties The properties of an add provider request.
 * @property providerName Recovery services provider name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationRecoveryServicesProviderArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<AddRecoveryServicesProviderInputPropertiesArgs>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationRecoveryServicesProviderArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationRecoveryServicesProviderArgs].
 */
@PulumiTagMarker
public class ReplicationRecoveryServicesProviderArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<AddRecoveryServicesProviderInputPropertiesArgs>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("xkhquobiafccbggy")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value The properties of an add provider request.
     */
    @JvmName("rxnyikoyayyltwjp")
    public suspend fun properties(`value`: Output<AddRecoveryServicesProviderInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Recovery services provider name.
     */
    @JvmName("wfjoasbmkvdsxscs")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("ifgivjlgxvhnxurs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("dfxpnjxwjjgadtju")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("wlhxsnieghsffmox")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value The properties of an add provider request.
     */
    @JvmName("eqldkylihyrqwwgc")
    public suspend fun properties(`value`: AddRecoveryServicesProviderInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of an add provider request.
     */
    @JvmName("ifwhwfunuqrmrwsb")
    public suspend
    fun properties(argument: suspend AddRecoveryServicesProviderInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AddRecoveryServicesProviderInputPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Recovery services provider name.
     */
    @JvmName("hxnmhkdmchvhjlwm")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("chybrcvqqmrfphdl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("wufaftvgfrfutmke")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationRecoveryServicesProviderArgs =
        ReplicationRecoveryServicesProviderArgs(
            fabricName = fabricName,
            properties = properties,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
}
