@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.ResourceGuardProxyBaseArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.ResourceGuardProxyBaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Create ResourceGuardProxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGuardProxy = new AzureNative.RecoveryServices.ResourceGuardProxy("resourceGuardProxy", new()
 *     {
 *         Properties = new AzureNative.RecoveryServices.Inputs.ResourceGuardProxyBaseArgs
 *         {
 *             ResourceGuardResourceId = "/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew",
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardProxyName = "swaggerExample",
 *         VaultName = "sampleVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewResourceGuardProxy(ctx, "resourceGuardProxy", &recoveryservices.ResourceGuardProxyArgs{
 * 			Properties: &recoveryservices.ResourceGuardProxyBaseArgs{
 * 				ResourceGuardResourceId: pulumi.String("/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew"),
 * 			},
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardProxyName: pulumi.String("swaggerExample"),
 * 			VaultName:              pulumi.String("sampleVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ResourceGuardProxy;
 * import com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.ResourceGuardProxyBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGuardProxy = new ResourceGuardProxy("resourceGuardProxy", ResourceGuardProxyArgs.builder()
 *             .properties(ResourceGuardProxyBaseArgs.builder()
 *                 .resourceGuardResourceId("/subscriptions/c999d45b-944f-418c-a0d8-c3fcfd1802c8/resourceGroups/vaultguardRGNew/providers/Microsoft.DataProtection/resourceGuards/VaultGuardTestNew")
 *                 .build())
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardProxyName("swaggerExample")
 *             .vaultName("sampleVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ResourceGuardProxy swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}
 * ```
 * @property eTag Optional ETag.
 * @property location Resource location.
 * @property properties ResourceGuardProxyBaseResource properties
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceGuardProxyName
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class ResourceGuardProxyArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ResourceGuardProxyBaseArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceGuardProxyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs =
        com.pulumi.azurenative.recoveryservices.ResourceGuardProxyArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceGuardProxyName(resourceGuardProxyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceGuardProxyArgs].
 */
@PulumiTagMarker
public class ResourceGuardProxyArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ResourceGuardProxyBaseArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceGuardProxyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("cggkypcciamdfjjp")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("spxeerkqqwvmjlhh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ResourceGuardProxyBaseResource properties
     */
    @JvmName("bbqehwxaxfverrnr")
    public suspend fun properties(`value`: Output<ResourceGuardProxyBaseArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("kijmueldajaqtcwe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("glcftkoxefenffxp")
    public suspend fun resourceGuardProxyName(`value`: Output<String>) {
        this.resourceGuardProxyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gtnxqcxspxafsewg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("nisdwuywjbviwtuf")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("cjgvotahvbcvipxa")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gqhghvycjjiopfgu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ResourceGuardProxyBaseResource properties
     */
    @JvmName("bjetsnkecxreflfo")
    public suspend fun properties(`value`: ResourceGuardProxyBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ResourceGuardProxyBaseResource properties
     */
    @JvmName("osqrjxyiwoqactxk")
    public suspend fun properties(argument: suspend ResourceGuardProxyBaseArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceGuardProxyBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("iyrorxwfhdlhwrwf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("itiwuoxbbjdeviai")
    public suspend fun resourceGuardProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardProxyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xkvpdxueycnjvcxf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("adatvmrrmpsuhsff")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("jekokfolkhvakhly")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ResourceGuardProxyArgs = ResourceGuardProxyArgs(
        eTag = eTag,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceGuardProxyName = resourceGuardProxyName,
        tags = tags,
        vaultName = vaultName,
    )
}
