@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityDataResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityDataResponse.Companion.toKotlin as identityDataResponseToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponse.Companion.toKotlin as vaultPropertiesResponseToKotlin

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.azurenative.recoveryservices.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Resource information, as returned by the resource provider.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2020-02-02, 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Create or Update Recovery Services vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.RecoveryServices.Vault("vault", new()
 *     {
 *         Identity = new AzureNative.RecoveryServices.Inputs.IdentityDataArgs
 *         {
 *             Type = AzureNative.RecoveryServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.RecoveryServices.Inputs.VaultPropertiesArgs
 *         {
 *             PublicNetworkAccess = AzureNative.RecoveryServices.PublicNetworkAccess.Enabled,
 *         },
 *         ResourceGroupName = "Default-RecoveryServices-ResourceGroup",
 *         Sku = new AzureNative.RecoveryServices.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.RecoveryServices.SkuName.Standard,
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewVault(ctx, "vault", &recoveryservices.VaultArgs{
 * 			Identity: &recoveryservices.IdentityDataArgs{
 * 				Type: pulumi.String(recoveryservices.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			Properties: &recoveryservices.VaultPropertiesArgs{
 * 				PublicNetworkAccess: pulumi.String(recoveryservices.PublicNetworkAccessEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-RecoveryServices-ResourceGroup"),
 * 			Sku: &recoveryservices.SkuArgs{
 * 				Name: pulumi.String(recoveryservices.SkuNameStandard),
 * 			},
 * 			VaultName: pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.Vault;
 * import com.pulumi.azurenative.recoveryservices.VaultArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.IdentityDataArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .identity(IdentityDataArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .publicNetworkAccess("Enabled")
 *                 .build())
 *             .resourceGroupName("Default-RecoveryServices-ResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Vault With Monitoring Setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.RecoveryServices.Vault("vault", new()
 *     {
 *         Identity = new AzureNative.RecoveryServices.Inputs.IdentityDataArgs
 *         {
 *             Type = AzureNative.RecoveryServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.RecoveryServices.Inputs.VaultPropertiesArgs
 *         {
 *             MonitoringSettings = new AzureNative.RecoveryServices.Inputs.MonitoringSettingsArgs
 *             {
 *                 AzureMonitorAlertSettings = new AzureNative.RecoveryServices.Inputs.AzureMonitorAlertSettingsArgs
 *                 {
 *                     AlertsForAllJobFailures = AzureNative.RecoveryServices.AlertsState.Enabled,
 *                 },
 *                 ClassicAlertSettings = new AzureNative.RecoveryServices.Inputs.ClassicAlertSettingsArgs
 *                 {
 *                     AlertsForCriticalOperations = AzureNative.RecoveryServices.AlertsState.Disabled,
 *                 },
 *             },
 *             PublicNetworkAccess = AzureNative.RecoveryServices.PublicNetworkAccess.Enabled,
 *         },
 *         ResourceGroupName = "Default-RecoveryServices-ResourceGroup",
 *         Sku = new AzureNative.RecoveryServices.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.RecoveryServices.SkuName.Standard,
 *         },
 *         VaultName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewVault(ctx, "vault", &recoveryservices.VaultArgs{
 * 			Identity: &recoveryservices.IdentityDataArgs{
 * 				Type: pulumi.String(recoveryservices.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			Properties: &recoveryservices.VaultPropertiesArgs{
 * 				MonitoringSettings: &recoveryservices.MonitoringSettingsArgs{
 * 					AzureMonitorAlertSettings: &recoveryservices.AzureMonitorAlertSettingsArgs{
 * 						AlertsForAllJobFailures: pulumi.String(recoveryservices.AlertsStateEnabled),
 * 					},
 * 					ClassicAlertSettings: &recoveryservices.ClassicAlertSettingsArgs{
 * 						AlertsForCriticalOperations: pulumi.String(recoveryservices.AlertsStateDisabled),
 * 					},
 * 				},
 * 				PublicNetworkAccess: pulumi.String(recoveryservices.PublicNetworkAccessEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-RecoveryServices-ResourceGroup"),
 * 			Sku: &recoveryservices.SkuArgs{
 * 				Name: pulumi.String(recoveryservices.SkuNameStandard),
 * 			},
 * 			VaultName: pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.Vault;
 * import com.pulumi.azurenative.recoveryservices.VaultArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.IdentityDataArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.MonitoringSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.AzureMonitorAlertSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .identity(IdentityDataArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .properties(VaultPropertiesArgs.builder()
 *                 .monitoringSettings(MonitoringSettingsArgs.builder()
 *                     .azureMonitorAlertSettings(AzureMonitorAlertSettingsArgs.builder()
 *                         .alertsForAllJobFailures("Enabled")
 *                         .build())
 *                     .classicAlertSettings(ClassicAlertSettingsArgs.builder()
 *                         .alertsForCriticalOperations("Disabled")
 *                         .build())
 *                     .build())
 *                 .publicNetworkAccess("Enabled")
 *                 .build())
 *             .resourceGroupName("Default-RecoveryServices-ResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .vaultName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:Vault swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}
 * ```
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * Optional ETag.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityDataResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the vault.
     */
    public val properties: Output<VaultPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                vaultPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Identifies the unique system identifier for each Azure resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.azurenative.recoveryservices.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
