@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.SkuName> {
    Standard(com.pulumi.azurenative.recoveryservices.enums.SkuName.Standard),
    RS0(com.pulumi.azurenative.recoveryservices.enums.SkuName.RS0),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
