@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureSqlProtectionPolicyArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure SQL workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureSql'.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy details.
 */
public data class AzureSqlProtectionPolicyArgs(
    public val backupManagementType: Output<String>,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val retentionPolicy:
    Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureSqlProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureSqlProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureSqlProtectionPolicyArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureSqlProtectionPolicyArgs].
 */
@PulumiTagMarker
public class AzureSqlProtectionPolicyArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var retentionPolicy:
        Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureSql'.
     */
    @JvmName("twrquygfurvxlqdy")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("ewnnoupybhkudngj")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("coslmrysxtfjenbq")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("efbgtswdukcetsup")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("nbgdyctnifsjfsgk")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Retention policy details.
     */
    @JvmName("actgnpeunqembdkw")
    public suspend
    fun retentionPolicy(`value`: Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>) {
        this.retentionPolicy = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureSql'.
     */
    @JvmName("dbgtiavqymijtery")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("dqlbiayrngccoqpn")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("lurfwciniahyuomf")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("jwllwnslwnehfloo")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Retention policy details.
     */
    @JvmName("arujlkxrkdhsyeag")
    public suspend
    fun retentionPolicy(`value`: Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy details.
     */
    @JvmName("dxsjteaxmahixgiq")
    public fun retentionPolicy(`value`: LongTermRetentionPolicyArgs) {
        val toBeMapped = Either.ofLeft<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy details.
     */
    @JvmName("jnehkcjhpympkbqu")
    public fun retentionPolicy(`value`: SimpleRetentionPolicyArgs) {
        val toBeMapped = Either.ofRight<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    internal fun build(): AzureSqlProtectionPolicyArgs = AzureSqlProtectionPolicyArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        retentionPolicy = retentionPolicy,
    )
}
