@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadSQLAutoProtectionIntentArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionStatus
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WorkloadItemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Workload SQL Auto Protection intent item.
 * @property backupManagementType Type of backup management for the backed up item.
 * @property itemId ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property protectionIntentItemType backup protectionIntent type.
 * Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
 * @property protectionState Backup state of this backup item.
 * @property sourceResourceId ARM ID of the resource to be backed up.
 * @property workloadItemType Workload item type of the item for which intent is to be set
 */
public data class AzureWorkloadSQLAutoProtectionIntentArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val itemId: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val protectionIntentItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionStatus>>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val workloadItemType: Output<Either<String, WorkloadItemType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadSQLAutoProtectionIntentArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadSQLAutoProtectionIntentArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadSQLAutoProtectionIntentArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .itemId(itemId?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .protectionIntentItemType(protectionIntentItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .workloadItemType(
                workloadItemType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [AzureWorkloadSQLAutoProtectionIntentArgs].
 */
@PulumiTagMarker
public class AzureWorkloadSQLAutoProtectionIntentArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var itemId: Output<String>? = null

    private var policyId: Output<String>? = null

    private var protectionIntentItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionStatus>>? = null

    private var sourceResourceId: Output<String>? = null

    private var workloadItemType: Output<Either<String, WorkloadItemType>>? = null

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("ivdrplrviclneepa")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
     */
    @JvmName("tyngtppxewblvrpx")
    public suspend fun itemId(`value`: Output<String>) {
        this.itemId = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("dsconfvneponpvjj")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value backup protectionIntent type.
     * Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
     */
    @JvmName("bkcvfdkfxkwoxbeu")
    public suspend fun protectionIntentItemType(`value`: Output<String>) {
        this.protectionIntentItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("vwqhmstovxddxapp")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionStatus>>) {
        this.protectionState = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("dehutjsymbmspeie")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Workload item type of the item for which intent is to be set
     */
    @JvmName("oyyyxbplhvjgarcd")
    public suspend fun workloadItemType(`value`: Output<Either<String, WorkloadItemType>>) {
        this.workloadItemType = value
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("oiylcchgdtwrqbww")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("gwnhvwyedgfbakue")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the backed up item.
     */
    @JvmName("xwyyimcrsubdbwvj")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
     */
    @JvmName("fxuuuhhimasapatt")
    public suspend fun itemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itemId = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("aoibwsjnppxdlmuo")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value backup protectionIntent type.
     * Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
     */
    @JvmName("opdivfactlxpgxjq")
    public suspend fun protectionIntentItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionIntentItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("mlhrbindwpbuskis")
    public suspend fun protectionState(`value`: Either<String, ProtectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("senjqegtvuusyedl")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("dsgirxofnpvdwyce")
    public fun protectionState(`value`: ProtectionStatus) {
        val toBeMapped = Either.ofRight<String, ProtectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("uslfvyafdpmsonjt")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Workload item type of the item for which intent is to be set
     */
    @JvmName("tebjabxnyrenmnpq")
    public suspend fun workloadItemType(`value`: Either<String, WorkloadItemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadItemType = mapped
    }

    /**
     * @param value Workload item type of the item for which intent is to be set
     */
    @JvmName("plgleyvgsaqwgeie")
    public fun workloadItemType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadItemType = mapped
    }

    /**
     * @param value Workload item type of the item for which intent is to be set
     */
    @JvmName("hcacisnpjokcntya")
    public fun workloadItemType(`value`: WorkloadItemType) {
        val toBeMapped = Either.ofRight<String, WorkloadItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadItemType = mapped
    }

    internal fun build(): AzureWorkloadSQLAutoProtectionIntentArgs =
        AzureWorkloadSQLAutoProtectionIntentArgs(
            backupManagementType = backupManagementType,
            itemId = itemId,
            policyId = policyId,
            protectionIntentItemType = protectionIntentItemType ?: throw
                PulumiNullFieldException("protectionIntentItemType"),
            protectionState = protectionState,
            sourceResourceId = sourceResourceId,
            workloadItemType = workloadItemType,
        )
}
