@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.AlertsState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for classic alerts
 * @property alertsForCriticalOperations
 */
public data class ClassicAlertSettingsArgs(
    public val alertsForCriticalOperations: Output<Either<String, AlertsState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ClassicAlertSettingsArgs.builder()
            .alertsForCriticalOperations(
                alertsForCriticalOperations?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ClassicAlertSettingsArgs].
 */
@PulumiTagMarker
public class ClassicAlertSettingsArgsBuilder internal constructor() {
    private var alertsForCriticalOperations: Output<Either<String, AlertsState>>? = null

    /**
     * @param value
     */
    @JvmName("roulcgdpeekgcduk")
    public suspend fun alertsForCriticalOperations(`value`: Output<Either<String, AlertsState>>) {
        this.alertsForCriticalOperations = value
    }

    /**
     * @param value
     */
    @JvmName("kffjohlgagphrcyj")
    public suspend fun alertsForCriticalOperations(`value`: Either<String, AlertsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertsForCriticalOperations = mapped
    }

    /**
     * @param value
     */
    @JvmName("cvpfmkapjjjgatir")
    public fun alertsForCriticalOperations(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlertsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertsForCriticalOperations = mapped
    }

    /**
     * @param value
     */
    @JvmName("qukumgkovwtdbwqs")
    public fun alertsForCriticalOperations(`value`: AlertsState) {
        val toBeMapped = Either.ofRight<String, AlertsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertsForCriticalOperations = mapped
    }

    internal fun build(): ClassicAlertSettingsArgs = ClassicAlertSettingsArgs(
        alertsForCriticalOperations = alertsForCriticalOperations,
    )
}
