@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectedItemState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Additional information on Backup engine specific backup item.
 * @property backupEngineName Backup Management server protecting this backup item
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Extended info of the backup item.
 * @property friendlyName Friendly name of the managed item
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemType backup item type.
 * Expected value is 'DPMProtectedItem'.
 * @property protectionState Protection state of the backup engine
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class DPMProtectedItemArgs(
    public val backupEngineName: Output<String>? = null,
    public val backupSetName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val extendedInfo: Output<DPMProtectedItemExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectedItemState>>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemArgs.builder()
            .backupEngineName(backupEngineName?.applyValue({ args0 -> args0 }))
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DPMProtectedItemArgs].
 */
@PulumiTagMarker
public class DPMProtectedItemArgsBuilder internal constructor() {
    private var backupEngineName: Output<String>? = null

    private var backupSetName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var extendedInfo: Output<DPMProtectedItemExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectedItemState>>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Backup Management server protecting this backup item
     */
    @JvmName("uejrlkhgtlromvqt")
    public suspend fun backupEngineName(`value`: Output<String>) {
        this.backupEngineName = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("ccavqvdvmrwstrqo")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("pmntsktrkysravof")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("fcdhfdtlbdnrcepv")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("ixqvknowdaxgmytq")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("ygfbqwbketkrgock")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Extended info of the backup item.
     */
    @JvmName("cbgqtcwgqqbrbjfx")
    public suspend fun extendedInfo(`value`: Output<DPMProtectedItemExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the managed item
     */
    @JvmName("jeckpwmebqmdoxqc")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("owacelsymhbxbfxj")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("soxqywqxgdqukuya")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("reqtfdmiwxdcfvfl")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("bxivyiuntmvqpvpy")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("eslqvcvxaabxlana")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("umefbpvbmsinqvos")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("vutjijlvnnmwtwjs")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'DPMProtectedItem'.
     */
    @JvmName("nplrdslwuehhcgex")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Protection state of the backup engine
     */
    @JvmName("peitwektpjkfrkxu")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectedItemState>>) {
        this.protectionState = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("iwkjsbcwdymuttxs")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("wlwwnjvcgdvoxlwj")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("vyganigoeptoxktg")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("gcxokvtfgwfqxgod")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("tqcudiqaiobmcgob")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Backup Management server protecting this backup item
     */
    @JvmName("ommgukkchxmydgxu")
    public suspend fun backupEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupEngineName = mapped
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("fpkrasexnqcvabjp")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("tjolptmcqkldedyi")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("lvgkdvplcvjjsexe")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("niqwaxmsorxxpvuq")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("bgbqioylbiykqjop")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("kofkypqcharsebxs")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("lheeqaoqjbeiyxhn")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Extended info of the backup item.
     */
    @JvmName("qdhuqfrydxcdqvhd")
    public suspend fun extendedInfo(`value`: DPMProtectedItemExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Extended info of the backup item.
     */
    @JvmName("ayapitrcueeacqev")
    public suspend
    fun extendedInfo(argument: suspend DPMProtectedItemExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DPMProtectedItemExtendedInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the managed item
     */
    @JvmName("heyjnegvifqlgega")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("qfncpcolyxmabdmf")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("vxnbdymlcoaickay")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("fkphuxbtlygqbunn")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("dfpyqvltsxswocii")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("lcgdqhlibjvxngvw")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("eacugeaqmxbnylec")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("hlveobhmsrvcdhsc")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'DPMProtectedItem'.
     */
    @JvmName("xutvtcsbrdgbhxlp")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Protection state of the backup engine
     */
    @JvmName("qnolngnquschmbgi")
    public suspend fun protectionState(`value`: Either<String, ProtectedItemState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Protection state of the backup engine
     */
    @JvmName("ukfdosddnnrvqmbb")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectedItemState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Protection state of the backup engine
     */
    @JvmName("hyiabnpbriubkyki")
    public fun protectionState(`value`: ProtectedItemState) {
        val toBeMapped = Either.ofRight<String, ProtectedItemState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("wqwroydixjmibhil")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("jyqvpnuoklnarlhm")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("oouubqyxhqqedtwt")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("avcvjpclbxtjnnnd")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): DPMProtectedItemArgs = DPMProtectedItemArgs(
        backupEngineName = backupEngineName,
        backupSetName = backupSetName,
        containerName = containerName,
        createMode = createMode,
        deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
        deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        isArchiveEnabled = isArchiveEnabled,
        isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
        isRehydrate = isRehydrate,
        isScheduledForDeferredDelete = isScheduledForDeferredDelete,
        lastRecoveryPoint = lastRecoveryPoint,
        policyId = policyId,
        policyName = policyName,
        protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
        protectionState = protectionState,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        sourceResourceId = sourceResourceId,
    )
}
