@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DailyRetentionFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Daily retention format.
 * @property daysOfTheMonth List of days of the month.
 */
public data class DailyRetentionFormatArgs(
    public val daysOfTheMonth: Output<List<DayArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DailyRetentionFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DailyRetentionFormatArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DailyRetentionFormatArgs.builder()
            .daysOfTheMonth(
                daysOfTheMonth?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DailyRetentionFormatArgs].
 */
@PulumiTagMarker
public class DailyRetentionFormatArgsBuilder internal constructor() {
    private var daysOfTheMonth: Output<List<DayArgs>>? = null

    /**
     * @param value List of days of the month.
     */
    @JvmName("tgabbinllnmxfigi")
    public suspend fun daysOfTheMonth(`value`: Output<List<DayArgs>>) {
        this.daysOfTheMonth = value
    }

    @JvmName("nxqttbdcyquwugkf")
    public suspend fun daysOfTheMonth(vararg values: Output<DayArgs>) {
        this.daysOfTheMonth = Output.all(values.asList())
    }

    /**
     * @param values List of days of the month.
     */
    @JvmName("buyiivhuvwkxwhpg")
    public suspend fun daysOfTheMonth(values: List<Output<DayArgs>>) {
        this.daysOfTheMonth = Output.all(values)
    }

    /**
     * @param value List of days of the month.
     */
    @JvmName("euauffnirqlebvfm")
    public suspend fun daysOfTheMonth(`value`: List<DayArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfTheMonth = mapped
    }

    /**
     * @param argument List of days of the month.
     */
    @JvmName("qupcopufnxtewvdm")
    public suspend fun daysOfTheMonth(argument: List<suspend DayArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DayArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.daysOfTheMonth = mapped
    }

    /**
     * @param argument List of days of the month.
     */
    @JvmName("sqyssdwmtpjiwuip")
    public suspend fun daysOfTheMonth(vararg argument: suspend DayArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DayArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.daysOfTheMonth = mapped
    }

    /**
     * @param argument List of days of the month.
     */
    @JvmName("bngwxfwsugtsamna")
    public suspend fun daysOfTheMonth(argument: suspend DayArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DayArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.daysOfTheMonth = mapped
    }

    /**
     * @param values List of days of the month.
     */
    @JvmName("ijvqpmsnvscgxpfi")
    public suspend fun daysOfTheMonth(vararg values: DayArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfTheMonth = mapped
    }

    internal fun build(): DailyRetentionFormatArgs = DailyRetentionFormatArgs(
        daysOfTheMonth = daysOfTheMonth,
    )
}
