@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.FabricCreationInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of site details provided during the time of site creation.
 * @property customDetails Fabric provider specific creation input.
 */
public data class FabricCreationInputPropertiesArgs(
    public val customDetails: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.FabricCreationInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.FabricCreationInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.FabricCreationInputPropertiesArgs.builder()
            .customDetails(customDetails?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FabricCreationInputPropertiesArgs].
 */
@PulumiTagMarker
public class FabricCreationInputPropertiesArgsBuilder internal constructor() {
    private var customDetails: Output<Any>? = null

    /**
     * @param value Fabric provider specific creation input.
     */
    @JvmName("diqugccywcnofwkm")
    public suspend fun customDetails(`value`: Output<Any>) {
        this.customDetails = value
    }

    /**
     * @param value Fabric provider specific creation input.
     */
    @JvmName("uflnxxcdhmklmcis")
    public suspend fun customDetails(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDetails = mapped
    }

    internal fun build(): FabricCreationInputPropertiesArgs = FabricCreationInputPropertiesArgs(
        customDetails = customDetails,
    )
}
