@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationNetworkMappingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Primary fabric name.
 * @property networkMappingName Network mapping name.
 * @property networkName Primary network name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationNetworkMappingPlainArgs(
    public val fabricName: String,
    public val networkMappingName: String,
    public val networkName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationNetworkMappingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationNetworkMappingPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationNetworkMappingPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .networkMappingName(networkMappingName.let({ args0 -> args0 }))
            .networkName(networkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationNetworkMappingPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationNetworkMappingPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var networkMappingName: String? = null

    private var networkName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Primary fabric name.
     */
    @JvmName("sbcaciwycivxsebt")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Network mapping name.
     */
    @JvmName("pqxhgrghucwcwhyi")
    public suspend fun networkMappingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkMappingName = mapped
    }

    /**
     * @param value Primary network name.
     */
    @JvmName("cqajjjkoloeqqaei")
    public suspend fun networkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("nlgxdyioykhnsyja")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("nhlwltqvrepnlmwc")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationNetworkMappingPlainArgs =
        GetReplicationNetworkMappingPlainArgs(
            fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
            networkMappingName = networkMappingName ?: throw PulumiNullFieldException("networkMappingName"),
            networkName = networkName ?: throw PulumiNullFieldException("networkName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
