@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationvCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 * @property vcenterName vcenter name.
 */
public data class GetReplicationvCenterPlainArgs(
    public val fabricName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val vcenterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationvCenterPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationvCenterPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationvCenterPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .vcenterName(vcenterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationvCenterPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationvCenterPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var vcenterName: String? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("mogdokggyjsmnyil")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("yqlccbypeoejxtcr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("gttphgjtqhnyyvwx")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value vcenter name.
     */
    @JvmName("ecaxnullxxcwmlbk")
    public suspend fun vcenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcenterName = mapped
    }

    internal fun build(): GetReplicationvCenterPlainArgs = GetReplicationvCenterPlainArgs(
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        vcenterName = vcenterName ?: throw PulumiNullFieldException("vcenterName"),
    )
}
