@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetResourceGuardProxyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceGuardProxyName
 * @property vaultName The name of the recovery services vault.
 */
public data class GetResourceGuardProxyPlainArgs(
    public val resourceGroupName: String,
    public val resourceGuardProxyName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetResourceGuardProxyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetResourceGuardProxyPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetResourceGuardProxyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceGuardProxyName(resourceGuardProxyName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceGuardProxyPlainArgs].
 */
@PulumiTagMarker
public class GetResourceGuardProxyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceGuardProxyName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("uipjpxbujqdwvyec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("khiibjrtrxycjpqd")
    public suspend fun resourceGuardProxyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGuardProxyName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("oxkbnjdlwofdpjuw")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetResourceGuardProxyPlainArgs = GetResourceGuardProxyPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceGuardProxyName = resourceGuardProxyName ?: throw
            PulumiNullFieldException("resourceGuardProxyName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
