@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzurePolicyInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Hyper-V Replica Azure specific input for creating a protection profile.
 * @property applicationConsistentSnapshotFrequencyInHours The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
 * @property instanceType The class type.
 * Expected value is 'HyperVReplicaAzure'.
 * @property onlineReplicationStartTime The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
 * @property recoveryPointHistoryDuration The duration (in hours) to which point the recovery history needs to be maintained.
 * @property replicationInterval The replication interval.
 * @property storageAccounts The list of storage accounts to which the VMs in the primary cloud can replicate to.
 */
public data class HyperVReplicaAzurePolicyInputArgs(
    public val applicationConsistentSnapshotFrequencyInHours: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val onlineReplicationStartTime: Output<String>? = null,
    public val recoveryPointHistoryDuration: Output<Int>? = null,
    public val replicationInterval: Output<Int>? = null,
    public val storageAccounts: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzurePolicyInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzurePolicyInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaAzurePolicyInputArgs.builder()
            .applicationConsistentSnapshotFrequencyInHours(
                applicationConsistentSnapshotFrequencyInHours?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .onlineReplicationStartTime(onlineReplicationStartTime?.applyValue({ args0 -> args0 }))
            .recoveryPointHistoryDuration(recoveryPointHistoryDuration?.applyValue({ args0 -> args0 }))
            .replicationInterval(replicationInterval?.applyValue({ args0 -> args0 }))
            .storageAccounts(storageAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [HyperVReplicaAzurePolicyInputArgs].
 */
@PulumiTagMarker
public class HyperVReplicaAzurePolicyInputArgsBuilder internal constructor() {
    private var applicationConsistentSnapshotFrequencyInHours: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var onlineReplicationStartTime: Output<String>? = null

    private var recoveryPointHistoryDuration: Output<Int>? = null

    private var replicationInterval: Output<Int>? = null

    private var storageAccounts: Output<List<String>>? = null

    /**
     * @param value The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
     */
    @JvmName("ixojeogdbcegqjqv")
    public suspend fun applicationConsistentSnapshotFrequencyInHours(`value`: Output<Int>) {
        this.applicationConsistentSnapshotFrequencyInHours = value
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplicaAzure'.
     */
    @JvmName("pcrqttwkgmmbglyh")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
     */
    @JvmName("xeuwknymrylkjhye")
    public suspend fun onlineReplicationStartTime(`value`: Output<String>) {
        this.onlineReplicationStartTime = value
    }

    /**
     * @param value The duration (in hours) to which point the recovery history needs to be maintained.
     */
    @JvmName("xohlbfidmdirkkau")
    public suspend fun recoveryPointHistoryDuration(`value`: Output<Int>) {
        this.recoveryPointHistoryDuration = value
    }

    /**
     * @param value The replication interval.
     */
    @JvmName("fbpqfampgnxkbotn")
    public suspend fun replicationInterval(`value`: Output<Int>) {
        this.replicationInterval = value
    }

    /**
     * @param value The list of storage accounts to which the VMs in the primary cloud can replicate to.
     */
    @JvmName("kwoeactmdyrljfml")
    public suspend fun storageAccounts(`value`: Output<List<String>>) {
        this.storageAccounts = value
    }

    @JvmName("peuffeeqpgtypxng")
    public suspend fun storageAccounts(vararg values: Output<String>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values The list of storage accounts to which the VMs in the primary cloud can replicate to.
     */
    @JvmName("eutoryxdmwxargmn")
    public suspend fun storageAccounts(values: List<Output<String>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
     */
    @JvmName("uvyoeknfejjnyxar")
    public suspend fun applicationConsistentSnapshotFrequencyInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConsistentSnapshotFrequencyInHours = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplicaAzure'.
     */
    @JvmName("onqdiiyfybndklkx")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
     */
    @JvmName("iwivjfoomehbyoyw")
    public suspend fun onlineReplicationStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlineReplicationStartTime = mapped
    }

    /**
     * @param value The duration (in hours) to which point the recovery history needs to be maintained.
     */
    @JvmName("twiueknpauevvkkb")
    public suspend fun recoveryPointHistoryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointHistoryDuration = mapped
    }

    /**
     * @param value The replication interval.
     */
    @JvmName("yuhnbemugjeodtsv")
    public suspend fun replicationInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInterval = mapped
    }

    /**
     * @param value The list of storage accounts to which the VMs in the primary cloud can replicate to.
     */
    @JvmName("tyloimkhbogedwet")
    public suspend fun storageAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param values The list of storage accounts to which the VMs in the primary cloud can replicate to.
     */
    @JvmName("xpxtsaanseujwioy")
    public suspend fun storageAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    internal fun build(): HyperVReplicaAzurePolicyInputArgs = HyperVReplicaAzurePolicyInputArgs(
        applicationConsistentSnapshotFrequencyInHours = applicationConsistentSnapshotFrequencyInHours,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        onlineReplicationStartTime = onlineReplicationStartTime,
        recoveryPointHistoryDuration = recoveryPointHistoryDuration,
        replicationInterval = replicationInterval,
        storageAccounts = storageAccounts,
    )
}
