@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaPolicyInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hyper-V Replica specific policy Input.
 * @property allowedAuthenticationType A value indicating the authentication type.
 * @property applicationConsistentSnapshotFrequencyInHours A value indicating the application consistent frequency.
 * @property compression A value indicating whether compression has to be enabled.
 * @property initialReplicationMethod A value indicating whether IR is online.
 * @property instanceType The class type.
 * Expected value is 'HyperVReplica2012'.
 * @property offlineReplicationExportPath A value indicating the offline IR export path.
 * @property offlineReplicationImportPath A value indicating the offline IR import path.
 * @property onlineReplicationStartTime A value indicating the online IR start time.
 * @property recoveryPoints A value indicating the number of recovery points.
 * @property replicaDeletion A value indicating whether the VM has to be auto deleted.
 * @property replicationPort A value indicating the recovery HTTPS port.
 */
public data class HyperVReplicaPolicyInputArgs(
    public val allowedAuthenticationType: Output<Int>? = null,
    public val applicationConsistentSnapshotFrequencyInHours: Output<Int>? = null,
    public val compression: Output<String>? = null,
    public val initialReplicationMethod: Output<String>? = null,
    public val instanceType: Output<String>,
    public val offlineReplicationExportPath: Output<String>? = null,
    public val offlineReplicationImportPath: Output<String>? = null,
    public val onlineReplicationStartTime: Output<String>? = null,
    public val recoveryPoints: Output<Int>? = null,
    public val replicaDeletion: Output<String>? = null,
    public val replicationPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaPolicyInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaPolicyInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.HyperVReplicaPolicyInputArgs.builder()
            .allowedAuthenticationType(allowedAuthenticationType?.applyValue({ args0 -> args0 }))
            .applicationConsistentSnapshotFrequencyInHours(
                applicationConsistentSnapshotFrequencyInHours?.applyValue({ args0 ->
                    args0
                }),
            )
            .compression(compression?.applyValue({ args0 -> args0 }))
            .initialReplicationMethod(initialReplicationMethod?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .offlineReplicationExportPath(offlineReplicationExportPath?.applyValue({ args0 -> args0 }))
            .offlineReplicationImportPath(offlineReplicationImportPath?.applyValue({ args0 -> args0 }))
            .onlineReplicationStartTime(onlineReplicationStartTime?.applyValue({ args0 -> args0 }))
            .recoveryPoints(recoveryPoints?.applyValue({ args0 -> args0 }))
            .replicaDeletion(replicaDeletion?.applyValue({ args0 -> args0 }))
            .replicationPort(replicationPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVReplicaPolicyInputArgs].
 */
@PulumiTagMarker
public class HyperVReplicaPolicyInputArgsBuilder internal constructor() {
    private var allowedAuthenticationType: Output<Int>? = null

    private var applicationConsistentSnapshotFrequencyInHours: Output<Int>? = null

    private var compression: Output<String>? = null

    private var initialReplicationMethod: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var offlineReplicationExportPath: Output<String>? = null

    private var offlineReplicationImportPath: Output<String>? = null

    private var onlineReplicationStartTime: Output<String>? = null

    private var recoveryPoints: Output<Int>? = null

    private var replicaDeletion: Output<String>? = null

    private var replicationPort: Output<Int>? = null

    /**
     * @param value A value indicating the authentication type.
     */
    @JvmName("kosexxbkjxvdjkle")
    public suspend fun allowedAuthenticationType(`value`: Output<Int>) {
        this.allowedAuthenticationType = value
    }

    /**
     * @param value A value indicating the application consistent frequency.
     */
    @JvmName("sqpvsfloewdsruia")
    public suspend fun applicationConsistentSnapshotFrequencyInHours(`value`: Output<Int>) {
        this.applicationConsistentSnapshotFrequencyInHours = value
    }

    /**
     * @param value A value indicating whether compression has to be enabled.
     */
    @JvmName("ppscadilcogbnehf")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value A value indicating whether IR is online.
     */
    @JvmName("dnlviawedhfdgpic")
    public suspend fun initialReplicationMethod(`value`: Output<String>) {
        this.initialReplicationMethod = value
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplica2012'.
     */
    @JvmName("mbuulitmuarpfxhb")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value A value indicating the offline IR export path.
     */
    @JvmName("tqusuxigikktugbn")
    public suspend fun offlineReplicationExportPath(`value`: Output<String>) {
        this.offlineReplicationExportPath = value
    }

    /**
     * @param value A value indicating the offline IR import path.
     */
    @JvmName("csckbtajnrfmpvln")
    public suspend fun offlineReplicationImportPath(`value`: Output<String>) {
        this.offlineReplicationImportPath = value
    }

    /**
     * @param value A value indicating the online IR start time.
     */
    @JvmName("wekpoqulikwlpbsd")
    public suspend fun onlineReplicationStartTime(`value`: Output<String>) {
        this.onlineReplicationStartTime = value
    }

    /**
     * @param value A value indicating the number of recovery points.
     */
    @JvmName("gfkifppjxiukiktq")
    public suspend fun recoveryPoints(`value`: Output<Int>) {
        this.recoveryPoints = value
    }

    /**
     * @param value A value indicating whether the VM has to be auto deleted.
     */
    @JvmName("cflcscwoxkeswtmn")
    public suspend fun replicaDeletion(`value`: Output<String>) {
        this.replicaDeletion = value
    }

    /**
     * @param value A value indicating the recovery HTTPS port.
     */
    @JvmName("sxlodtbcycyjcouk")
    public suspend fun replicationPort(`value`: Output<Int>) {
        this.replicationPort = value
    }

    /**
     * @param value A value indicating the authentication type.
     */
    @JvmName("onqhquecnrlfryxo")
    public suspend fun allowedAuthenticationType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAuthenticationType = mapped
    }

    /**
     * @param value A value indicating the application consistent frequency.
     */
    @JvmName("rvwcpqtlmkslyhyi")
    public suspend fun applicationConsistentSnapshotFrequencyInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConsistentSnapshotFrequencyInHours = mapped
    }

    /**
     * @param value A value indicating whether compression has to be enabled.
     */
    @JvmName("tvujmukriymqirnj")
    public suspend fun compression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value A value indicating whether IR is online.
     */
    @JvmName("jttdjamebcwaqsji")
    public suspend fun initialReplicationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialReplicationMethod = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'HyperVReplica2012'.
     */
    @JvmName("santdqqtomennxdq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value A value indicating the offline IR export path.
     */
    @JvmName("jrdawdooovejursw")
    public suspend fun offlineReplicationExportPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineReplicationExportPath = mapped
    }

    /**
     * @param value A value indicating the offline IR import path.
     */
    @JvmName("cnvxpescnojuvuue")
    public suspend fun offlineReplicationImportPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineReplicationImportPath = mapped
    }

    /**
     * @param value A value indicating the online IR start time.
     */
    @JvmName("bfcnsnqfjspxvmun")
    public suspend fun onlineReplicationStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlineReplicationStartTime = mapped
    }

    /**
     * @param value A value indicating the number of recovery points.
     */
    @JvmName("mdsageaofhxrgjqn")
    public suspend fun recoveryPoints(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPoints = mapped
    }

    /**
     * @param value A value indicating whether the VM has to be auto deleted.
     */
    @JvmName("nfljohdgwoxqakrl")
    public suspend fun replicaDeletion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaDeletion = mapped
    }

    /**
     * @param value A value indicating the recovery HTTPS port.
     */
    @JvmName("iutsiobjojwoehqi")
    public suspend fun replicationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationPort = mapped
    }

    internal fun build(): HyperVReplicaPolicyInputArgs = HyperVReplicaPolicyInputArgs(
        allowedAuthenticationType = allowedAuthenticationType,
        applicationConsistentSnapshotFrequencyInHours = applicationConsistentSnapshotFrequencyInHours,
        compression = compression,
        initialReplicationMethod = initialReplicationMethod,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        offlineReplicationExportPath = offlineReplicationExportPath,
        offlineReplicationImportPath = offlineReplicationImportPath,
        onlineReplicationStartTime = onlineReplicationStartTime,
        recoveryPoints = recoveryPoints,
        replicaDeletion = replicaDeletion,
        replicationPort = replicationPort,
    )
}
