@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2EnableProtectionInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.DiskAccountType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.LicenseType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SqlServerLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VMware Azure specific enable protection input.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskType The DiskType.
 * @property disksToInclude The disks to include list.
 * @property enableRdpOnTargetOption The selected option to enable RDP\SSH on target VM after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
 * @property instanceType The class type.
 * Expected value is 'InMageAzureV2'.
 * @property licenseType License type.
 * @property logStorageAccountId The storage account to be used for logging during replication.
 * @property masterTargetId The Master target Id.
 * @property multiVmGroupId The multi VM group Id.
 * @property multiVmGroupName The multi VM group name.
 * @property processServerId The Process Server Id.
 * @property runAsAccountId The CS account Id.
 * @property seedManagedDiskTags The tags for the seed managed disks.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property storageAccountId The storage account Id.
 * @property targetAvailabilitySetId The target availability set ARM Id for resource manager deployment.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetAzureNetworkId The selected target Azure network Id.
 * @property targetAzureSubnetId The selected target Azure subnet Id.
 * @property targetAzureV1ResourceGroupId The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
 * @property targetAzureV2ResourceGroupId The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
 * @property targetAzureVmName The target azure VM Name.
 * @property targetManagedDiskTags The tags for the target managed disks.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The proximity placement group ARM Id.
 * @property targetVmSize The target VM size.
 * @property targetVmTags The target VM tags.
 */
public data class InMageAzureV2EnableProtectionInputArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskType: Output<Either<String, DiskAccountType>>? = null,
    public val disksToInclude: Output<List<InMageAzureV2DiskInputDetailsArgs>>? = null,
    public val enableRdpOnTargetOption: Output<String>? = null,
    public val instanceType: Output<String>,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val logStorageAccountId: Output<String>? = null,
    public val masterTargetId: Output<String>? = null,
    public val multiVmGroupId: Output<String>? = null,
    public val multiVmGroupName: Output<String>? = null,
    public val processServerId: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val seedManagedDiskTags: Output<Map<String, String>>? = null,
    public val sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null,
    public val storageAccountId: Output<String>? = null,
    public val targetAvailabilitySetId: Output<String>? = null,
    public val targetAvailabilityZone: Output<String>? = null,
    public val targetAzureNetworkId: Output<String>? = null,
    public val targetAzureSubnetId: Output<String>? = null,
    public val targetAzureV1ResourceGroupId: Output<String>? = null,
    public val targetAzureV2ResourceGroupId: Output<String>? = null,
    public val targetAzureVmName: Output<String>? = null,
    public val targetManagedDiskTags: Output<Map<String, String>>? = null,
    public val targetNicTags: Output<Map<String, String>>? = null,
    public val targetProximityPlacementGroupId: Output<String>? = null,
    public val targetVmSize: Output<String>? = null,
    public val targetVmTags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2EnableProtectionInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2EnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageAzureV2EnableProtectionInputArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disksToInclude(
                disksToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableRdpOnTargetOption(enableRdpOnTargetOption?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logStorageAccountId(logStorageAccountId?.applyValue({ args0 -> args0 }))
            .masterTargetId(masterTargetId?.applyValue({ args0 -> args0 }))
            .multiVmGroupId(multiVmGroupId?.applyValue({ args0 -> args0 }))
            .multiVmGroupName(multiVmGroupName?.applyValue({ args0 -> args0 }))
            .processServerId(processServerId?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .seedManagedDiskTags(
                seedManagedDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sqlServerLicenseType(
                sqlServerLicenseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .targetAvailabilitySetId(targetAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .targetAvailabilityZone(targetAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetAzureNetworkId(targetAzureNetworkId?.applyValue({ args0 -> args0 }))
            .targetAzureSubnetId(targetAzureSubnetId?.applyValue({ args0 -> args0 }))
            .targetAzureV1ResourceGroupId(targetAzureV1ResourceGroupId?.applyValue({ args0 -> args0 }))
            .targetAzureV2ResourceGroupId(targetAzureV2ResourceGroupId?.applyValue({ args0 -> args0 }))
            .targetAzureVmName(targetAzureVmName?.applyValue({ args0 -> args0 }))
            .targetManagedDiskTags(
                targetManagedDiskTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetNicTags(
                targetNicTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetProximityPlacementGroupId(targetProximityPlacementGroupId?.applyValue({ args0 -> args0 }))
            .targetVmSize(targetVmSize?.applyValue({ args0 -> args0 }))
            .targetVmTags(
                targetVmTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InMageAzureV2EnableProtectionInputArgs].
 */
@PulumiTagMarker
public class InMageAzureV2EnableProtectionInputArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var diskType: Output<Either<String, DiskAccountType>>? = null

    private var disksToInclude: Output<List<InMageAzureV2DiskInputDetailsArgs>>? = null

    private var enableRdpOnTargetOption: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var logStorageAccountId: Output<String>? = null

    private var masterTargetId: Output<String>? = null

    private var multiVmGroupId: Output<String>? = null

    private var multiVmGroupName: Output<String>? = null

    private var processServerId: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var seedManagedDiskTags: Output<Map<String, String>>? = null

    private var sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null

    private var storageAccountId: Output<String>? = null

    private var targetAvailabilitySetId: Output<String>? = null

    private var targetAvailabilityZone: Output<String>? = null

    private var targetAzureNetworkId: Output<String>? = null

    private var targetAzureSubnetId: Output<String>? = null

    private var targetAzureV1ResourceGroupId: Output<String>? = null

    private var targetAzureV2ResourceGroupId: Output<String>? = null

    private var targetAzureVmName: Output<String>? = null

    private var targetManagedDiskTags: Output<Map<String, String>>? = null

    private var targetNicTags: Output<Map<String, String>>? = null

    private var targetProximityPlacementGroupId: Output<String>? = null

    private var targetVmSize: Output<String>? = null

    private var targetVmTags: Output<Map<String, String>>? = null

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("qitvyjhxubhuhbjo")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("yonbypnmvfhdaqni")
    public suspend fun diskType(`value`: Output<Either<String, DiskAccountType>>) {
        this.diskType = value
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("cfwmsonguypdmahf")
    public suspend fun disksToInclude(`value`: Output<List<InMageAzureV2DiskInputDetailsArgs>>) {
        this.disksToInclude = value
    }

    @JvmName("xkrjafdxjmbnjkvh")
    public suspend fun disksToInclude(vararg values: Output<InMageAzureV2DiskInputDetailsArgs>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("pelyoebvgjitnbyk")
    public suspend fun disksToInclude(values: List<Output<InMageAzureV2DiskInputDetailsArgs>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value The selected option to enable RDP\SSH on target VM after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
     */
    @JvmName("qtsfpdnkjqqfqtsy")
    public suspend fun enableRdpOnTargetOption(`value`: Output<String>) {
        this.enableRdpOnTargetOption = value
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageAzureV2'.
     */
    @JvmName("floiokadopdjmjog")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value License type.
     */
    @JvmName("cntfwifeanrayytl")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The storage account to be used for logging during replication.
     */
    @JvmName("nkxqlfttyiobckog")
    public suspend fun logStorageAccountId(`value`: Output<String>) {
        this.logStorageAccountId = value
    }

    /**
     * @param value The Master target Id.
     */
    @JvmName("vpgtckgruhtaotde")
    public suspend fun masterTargetId(`value`: Output<String>) {
        this.masterTargetId = value
    }

    /**
     * @param value The multi VM group Id.
     */
    @JvmName("lqyydjiispdxpirb")
    public suspend fun multiVmGroupId(`value`: Output<String>) {
        this.multiVmGroupId = value
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("cpgfhvkifrdjmtbl")
    public suspend fun multiVmGroupName(`value`: Output<String>) {
        this.multiVmGroupName = value
    }

    /**
     * @param value The Process Server Id.
     */
    @JvmName("suwgxvcgqyohmsqd")
    public suspend fun processServerId(`value`: Output<String>) {
        this.processServerId = value
    }

    /**
     * @param value The CS account Id.
     */
    @JvmName("readpimtcvfqtxpf")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value The tags for the seed managed disks.
     */
    @JvmName("ocjfwalpnctnvjxo")
    public suspend fun seedManagedDiskTags(`value`: Output<Map<String, String>>) {
        this.seedManagedDiskTags = value
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("skhevkvqjjhbwyly")
    public suspend fun sqlServerLicenseType(`value`: Output<Either<String, SqlServerLicenseType>>) {
        this.sqlServerLicenseType = value
    }

    /**
     * @param value The storage account Id.
     */
    @JvmName("qeqspjlsvdjpymsq")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The target availability set ARM Id for resource manager deployment.
     */
    @JvmName("qmogtquyerqcisvt")
    public suspend fun targetAvailabilitySetId(`value`: Output<String>) {
        this.targetAvailabilitySetId = value
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("vitqmlfmubqxruei")
    public suspend fun targetAvailabilityZone(`value`: Output<String>) {
        this.targetAvailabilityZone = value
    }

    /**
     * @param value The selected target Azure network Id.
     */
    @JvmName("xkmnydyikegpywjs")
    public suspend fun targetAzureNetworkId(`value`: Output<String>) {
        this.targetAzureNetworkId = value
    }

    /**
     * @param value The selected target Azure subnet Id.
     */
    @JvmName("ujcojhpkiyumejbo")
    public suspend fun targetAzureSubnetId(`value`: Output<String>) {
        this.targetAzureSubnetId = value
    }

    /**
     * @param value The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
     */
    @JvmName("cpdwvplclkyuepvs")
    public suspend fun targetAzureV1ResourceGroupId(`value`: Output<String>) {
        this.targetAzureV1ResourceGroupId = value
    }

    /**
     * @param value The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
     */
    @JvmName("rrdbeidwdxkgnljr")
    public suspend fun targetAzureV2ResourceGroupId(`value`: Output<String>) {
        this.targetAzureV2ResourceGroupId = value
    }

    /**
     * @param value The target azure VM Name.
     */
    @JvmName("nmvnogclktxevumj")
    public suspend fun targetAzureVmName(`value`: Output<String>) {
        this.targetAzureVmName = value
    }

    /**
     * @param value The tags for the target managed disks.
     */
    @JvmName("fgmcvcjmqafcjgxd")
    public suspend fun targetManagedDiskTags(`value`: Output<Map<String, String>>) {
        this.targetManagedDiskTags = value
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("iyrglnxahkujibct")
    public suspend fun targetNicTags(`value`: Output<Map<String, String>>) {
        this.targetNicTags = value
    }

    /**
     * @param value The proximity placement group ARM Id.
     */
    @JvmName("ghkloytkjqltccja")
    public suspend fun targetProximityPlacementGroupId(`value`: Output<String>) {
        this.targetProximityPlacementGroupId = value
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("lbjokjurijeyivhi")
    public suspend fun targetVmSize(`value`: Output<String>) {
        this.targetVmSize = value
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("gdtilwxmjtdueyif")
    public suspend fun targetVmTags(`value`: Output<Map<String, String>>) {
        this.targetVmTags = value
    }

    /**
     * @param value The DiskEncryptionSet ARM Id.
     */
    @JvmName("methikjmrbfqalay")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("mbdcfiwrgsbjoiha")
    public suspend fun diskType(`value`: Either<String, DiskAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("inffooaefxeyebyi")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The DiskType.
     */
    @JvmName("ixigtbrmudtcyunk")
    public fun diskType(`value`: DiskAccountType) {
        val toBeMapped = Either.ofRight<String, DiskAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("tqjqsinicxeupqrm")
    public suspend fun disksToInclude(`value`: List<InMageAzureV2DiskInputDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("mcdfgncaxycymfxa")
    public suspend
    fun disksToInclude(argument: List<suspend InMageAzureV2DiskInputDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InMageAzureV2DiskInputDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("xvekjcdiacxdvyyx")
    public suspend fun disksToInclude(
        vararg
        argument: suspend InMageAzureV2DiskInputDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InMageAzureV2DiskInputDetailsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("ahqdsbgaalopdwpg")
    public suspend
    fun disksToInclude(argument: suspend InMageAzureV2DiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InMageAzureV2DiskInputDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("yxutsxxbdesgcnwt")
    public suspend fun disksToInclude(vararg values: InMageAzureV2DiskInputDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value The selected option to enable RDP\SSH on target VM after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
     */
    @JvmName("tesmfbdhludxfjla")
    public suspend fun enableRdpOnTargetOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRdpOnTargetOption = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageAzureV2'.
     */
    @JvmName("wcwrmiatxyopjjyh")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("cicyvwabqmungppf")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("ovimtkilhnyspjeh")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type.
     */
    @JvmName("fxgxuenmogviveuf")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The storage account to be used for logging during replication.
     */
    @JvmName("lmaynxhlxxglcufy")
    public suspend fun logStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorageAccountId = mapped
    }

    /**
     * @param value The Master target Id.
     */
    @JvmName("tohykwvtrywxjetm")
    public suspend fun masterTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterTargetId = mapped
    }

    /**
     * @param value The multi VM group Id.
     */
    @JvmName("mvftroyehkauayvr")
    public suspend fun multiVmGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupId = mapped
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("eccajblohodxoneq")
    public suspend fun multiVmGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupName = mapped
    }

    /**
     * @param value The Process Server Id.
     */
    @JvmName("jxcweyewfdvmfmau")
    public suspend fun processServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processServerId = mapped
    }

    /**
     * @param value The CS account Id.
     */
    @JvmName("owdibfhqfmfgjume")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value The tags for the seed managed disks.
     */
    @JvmName("rsvduhjvevlolyog")
    public suspend fun seedManagedDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seedManagedDiskTags = mapped
    }

    /**
     * @param values The tags for the seed managed disks.
     */
    @JvmName("ccqheswogrufocdr")
    public fun seedManagedDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.seedManagedDiskTags = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("rmfjtkgkroytpmka")
    public suspend fun sqlServerLicenseType(`value`: Either<String, SqlServerLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("ntwstyyjnpyyughp")
    public fun sqlServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The SQL Server license type.
     */
    @JvmName("tcpytwhcjdymtmly")
    public fun sqlServerLicenseType(`value`: SqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value The storage account Id.
     */
    @JvmName("rhxoitpfrsyttcll")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The target availability set ARM Id for resource manager deployment.
     */
    @JvmName("pquhqhhdesbstotk")
    public suspend fun targetAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilitySetId = mapped
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("rlmqxtfalpnwwxls")
    public suspend fun targetAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value The selected target Azure network Id.
     */
    @JvmName("ovifjwnhodhfexuc")
    public suspend fun targetAzureNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureNetworkId = mapped
    }

    /**
     * @param value The selected target Azure subnet Id.
     */
    @JvmName("strungdmnwjxuoar")
    public suspend fun targetAzureSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureSubnetId = mapped
    }

    /**
     * @param value The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
     */
    @JvmName("qisfmjhuhpsfjgov")
    public suspend fun targetAzureV1ResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureV1ResourceGroupId = mapped
    }

    /**
     * @param value The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
     */
    @JvmName("cfcxepvojtkjkahi")
    public suspend fun targetAzureV2ResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureV2ResourceGroupId = mapped
    }

    /**
     * @param value The target azure VM Name.
     */
    @JvmName("jrwkedxsawtolwdv")
    public suspend fun targetAzureVmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAzureVmName = mapped
    }

    /**
     * @param value The tags for the target managed disks.
     */
    @JvmName("rlpgttktxhrqtduk")
    public suspend fun targetManagedDiskTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetManagedDiskTags = mapped
    }

    /**
     * @param values The tags for the target managed disks.
     */
    @JvmName("wwrjssltqxamibgv")
    public fun targetManagedDiskTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetManagedDiskTags = mapped
    }

    /**
     * @param value The tags for the target NICs.
     */
    @JvmName("tkxnbkrkdxgxxmdi")
    public suspend fun targetNicTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param values The tags for the target NICs.
     */
    @JvmName("rjvbnqnsnmvwaxwc")
    public fun targetNicTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNicTags = mapped
    }

    /**
     * @param value The proximity placement group ARM Id.
     */
    @JvmName("lhmtuglxpfbplowp")
    public suspend fun targetProximityPlacementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProximityPlacementGroupId = mapped
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("vjtdjblopfqiwkpr")
    public suspend fun targetVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSize = mapped
    }

    /**
     * @param value The target VM tags.
     */
    @JvmName("nsnjuuejohvrbsss")
    public suspend fun targetVmTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    /**
     * @param values The target VM tags.
     */
    @JvmName("mkfmyxdlqhqpfijy")
    public fun targetVmTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVmTags = mapped
    }

    internal fun build(): InMageAzureV2EnableProtectionInputArgs =
        InMageAzureV2EnableProtectionInputArgs(
            diskEncryptionSetId = diskEncryptionSetId,
            diskType = diskType,
            disksToInclude = disksToInclude,
            enableRdpOnTargetOption = enableRdpOnTargetOption,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            licenseType = licenseType,
            logStorageAccountId = logStorageAccountId,
            masterTargetId = masterTargetId,
            multiVmGroupId = multiVmGroupId,
            multiVmGroupName = multiVmGroupName,
            processServerId = processServerId,
            runAsAccountId = runAsAccountId,
            seedManagedDiskTags = seedManagedDiskTags,
            sqlServerLicenseType = sqlServerLicenseType,
            storageAccountId = storageAccountId,
            targetAvailabilitySetId = targetAvailabilitySetId,
            targetAvailabilityZone = targetAvailabilityZone,
            targetAzureNetworkId = targetAzureNetworkId,
            targetAzureSubnetId = targetAzureSubnetId,
            targetAzureV1ResourceGroupId = targetAzureV1ResourceGroupId,
            targetAzureV2ResourceGroupId = targetAzureV2ResourceGroupId,
            targetAzureVmName = targetAzureVmName,
            targetManagedDiskTags = targetManagedDiskTags,
            targetNicTags = targetNicTags,
            targetProximityPlacementGroupId = targetProximityPlacementGroupId,
            targetVmSize = targetVmSize,
            targetVmTags = targetVmTags,
        )
}
