@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InstantRPAdditionalDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureBackupRGNamePrefix
 * @property azureBackupRGNameSuffix
 */
public data class InstantRPAdditionalDetailsArgs(
    public val azureBackupRGNamePrefix: Output<String>? = null,
    public val azureBackupRGNameSuffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InstantRPAdditionalDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InstantRPAdditionalDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InstantRPAdditionalDetailsArgs.builder()
            .azureBackupRGNamePrefix(azureBackupRGNamePrefix?.applyValue({ args0 -> args0 }))
            .azureBackupRGNameSuffix(azureBackupRGNameSuffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstantRPAdditionalDetailsArgs].
 */
@PulumiTagMarker
public class InstantRPAdditionalDetailsArgsBuilder internal constructor() {
    private var azureBackupRGNamePrefix: Output<String>? = null

    private var azureBackupRGNameSuffix: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ylaosbwxgdxjtjwp")
    public suspend fun azureBackupRGNamePrefix(`value`: Output<String>) {
        this.azureBackupRGNamePrefix = value
    }

    /**
     * @param value
     */
    @JvmName("mjyjmmtxtdosnsja")
    public suspend fun azureBackupRGNameSuffix(`value`: Output<String>) {
        this.azureBackupRGNameSuffix = value
    }

    /**
     * @param value
     */
    @JvmName("tqyjwxatoiysvlno")
    public suspend fun azureBackupRGNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBackupRGNamePrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibcjhngsgfktvaif")
    public suspend fun azureBackupRGNameSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBackupRGNameSuffix = mapped
    }

    internal fun build(): InstantRPAdditionalDetailsArgs = InstantRPAdditionalDetailsArgs(
        azureBackupRGNamePrefix = azureBackupRGNamePrefix,
        azureBackupRGNameSuffix = azureBackupRGNameSuffix,
    )
}
