@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MABContainerHealthDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * MAB workload-specific Health Details.
 * @property code Health Code
 * @property message Health Message
 * @property recommendations Health Recommended Actions
 * @property title Health Title
 */
public data class MABContainerHealthDetailsArgs(
    public val code: Output<Int>? = null,
    public val message: Output<String>? = null,
    public val recommendations: Output<List<String>>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MABContainerHealthDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.MABContainerHealthDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MABContainerHealthDetailsArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .recommendations(recommendations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MABContainerHealthDetailsArgs].
 */
@PulumiTagMarker
public class MABContainerHealthDetailsArgsBuilder internal constructor() {
    private var code: Output<Int>? = null

    private var message: Output<String>? = null

    private var recommendations: Output<List<String>>? = null

    private var title: Output<String>? = null

    /**
     * @param value Health Code
     */
    @JvmName("exousifcaaytdytv")
    public suspend fun code(`value`: Output<Int>) {
        this.code = value
    }

    /**
     * @param value Health Message
     */
    @JvmName("gvbvgitsxjlmckbe")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Health Recommended Actions
     */
    @JvmName("tnohbfcnkvqvibko")
    public suspend fun recommendations(`value`: Output<List<String>>) {
        this.recommendations = value
    }

    @JvmName("bkshxybbfmabjdcn")
    public suspend fun recommendations(vararg values: Output<String>) {
        this.recommendations = Output.all(values.asList())
    }

    /**
     * @param values Health Recommended Actions
     */
    @JvmName("jjdaqofjccgofroi")
    public suspend fun recommendations(values: List<Output<String>>) {
        this.recommendations = Output.all(values)
    }

    /**
     * @param value Health Title
     */
    @JvmName("vcipjaatxgvqpici")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Health Code
     */
    @JvmName("whoeqetgudtarklv")
    public suspend fun code(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Health Message
     */
    @JvmName("ohcgvonwvqohvxso")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Health Recommended Actions
     */
    @JvmName("eivbjmsxvclrqgxr")
    public suspend fun recommendations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendations = mapped
    }

    /**
     * @param values Health Recommended Actions
     */
    @JvmName("kmrsuomepnjxtugy")
    public suspend fun recommendations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendations = mapped
    }

    /**
     * @param value Health Title
     */
    @JvmName("hirultunggomrlii")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): MABContainerHealthDetailsArgs = MABContainerHealthDetailsArgs(
        code = code,
        message = message,
        recommendations = recommendations,
        title = title,
    )
}
