@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information on the backed up item.
 * @property lastRefreshedAt Last time when the agent data synced to service.
 * @property oldestRecoveryPoint The oldest backup copy available.
 * @property recoveryPointCount Number of backup copies associated with the backup item.
 */
public data class MabFileFolderProtectedItemExtendedInfoArgs(
    public val lastRefreshedAt: Output<String>? = null,
    public val oldestRecoveryPoint: Output<String>? = null,
    public val recoveryPointCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemExtendedInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MabFileFolderProtectedItemExtendedInfoArgs.builder()
            .lastRefreshedAt(lastRefreshedAt?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPoint(oldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .recoveryPointCount(recoveryPointCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MabFileFolderProtectedItemExtendedInfoArgs].
 */
@PulumiTagMarker
public class MabFileFolderProtectedItemExtendedInfoArgsBuilder internal constructor() {
    private var lastRefreshedAt: Output<String>? = null

    private var oldestRecoveryPoint: Output<String>? = null

    private var recoveryPointCount: Output<Int>? = null

    /**
     * @param value Last time when the agent data synced to service.
     */
    @JvmName("oaphapijnihdaran")
    public suspend fun lastRefreshedAt(`value`: Output<String>) {
        this.lastRefreshedAt = value
    }

    /**
     * @param value The oldest backup copy available.
     */
    @JvmName("rduhjnhmsfkvcuqn")
    public suspend fun oldestRecoveryPoint(`value`: Output<String>) {
        this.oldestRecoveryPoint = value
    }

    /**
     * @param value Number of backup copies associated with the backup item.
     */
    @JvmName("wqnnowxuucertojy")
    public suspend fun recoveryPointCount(`value`: Output<Int>) {
        this.recoveryPointCount = value
    }

    /**
     * @param value Last time when the agent data synced to service.
     */
    @JvmName("ffldntmeilyloujb")
    public suspend fun lastRefreshedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRefreshedAt = mapped
    }

    /**
     * @param value The oldest backup copy available.
     */
    @JvmName("vglxnxgpcsexnlli")
    public suspend fun oldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPoint = mapped
    }

    /**
     * @param value Number of backup copies associated with the backup item.
     */
    @JvmName("onraotvddeprfooo")
    public suspend fun recoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointCount = mapped
    }

    internal fun build(): MabFileFolderProtectedItemExtendedInfoArgs =
        MabFileFolderProtectedItemExtendedInfoArgs(
            lastRefreshedAt = lastRefreshedAt,
            oldestRecoveryPoint = oldestRecoveryPoint,
            recoveryPointCount = recoveryPointCount,
        )
}
