@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanActionArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.PossibleOperationsDirections
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ReplicationProtectedItemOperation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Recovery plan action details.
 * @property actionName The action name.
 * @property customDetails The custom details.
 * @property failoverDirections The list of failover directions.
 * @property failoverTypes The list of failover types.
 */
public data class RecoveryPlanActionArgs(
    public val actionName: Output<String>,
    public val customDetails: Output<Any>,
    public val failoverDirections: Output<List<Either<String, PossibleOperationsDirections>>>,
    public val failoverTypes: Output<List<Either<String, ReplicationProtectedItemOperation>>>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanActionArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanActionArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RecoveryPlanActionArgs.builder()
            .actionName(actionName.applyValue({ args0 -> args0 }))
            .customDetails(customDetails.applyValue({ args0 -> args0 }))
            .failoverDirections(
                failoverDirections.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .failoverTypes(
                failoverTypes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [RecoveryPlanActionArgs].
 */
@PulumiTagMarker
public class RecoveryPlanActionArgsBuilder internal constructor() {
    private var actionName: Output<String>? = null

    private var customDetails: Output<Any>? = null

    private var failoverDirections: Output<List<Either<String, PossibleOperationsDirections>>>? = null

    private var failoverTypes: Output<List<Either<String, ReplicationProtectedItemOperation>>>? = null

    /**
     * @param value The action name.
     */
    @JvmName("vrccfvdklnbugjca")
    public suspend fun actionName(`value`: Output<String>) {
        this.actionName = value
    }

    /**
     * @param value The custom details.
     */
    @JvmName("jdxmbmajpwgajxyl")
    public suspend fun customDetails(`value`: Output<Any>) {
        this.customDetails = value
    }

    /**
     * @param value The list of failover directions.
     */
    @JvmName("chicmbrmaeuogdsu")
    public suspend
    fun failoverDirections(`value`: Output<List<Either<String, PossibleOperationsDirections>>>) {
        this.failoverDirections = value
    }

    @JvmName("xjyifnsuxwyiqueq")
    public suspend fun failoverDirections(
        vararg
        values: Output<Either<String, PossibleOperationsDirections>>,
    ) {
        this.failoverDirections = Output.all(values.asList())
    }

    /**
     * @param values The list of failover directions.
     */
    @JvmName("caqfxomaefcqipbg")
    public suspend
    fun failoverDirections(values: List<Output<Either<String, PossibleOperationsDirections>>>) {
        this.failoverDirections = Output.all(values)
    }

    /**
     * @param value The list of failover types.
     */
    @JvmName("rxlmxxsedbarxmyt")
    public suspend
    fun failoverTypes(`value`: Output<List<Either<String, ReplicationProtectedItemOperation>>>) {
        this.failoverTypes = value
    }

    @JvmName("kgpqomogiabayumn")
    public suspend fun failoverTypes(
        vararg
        values: Output<Either<String, ReplicationProtectedItemOperation>>,
    ) {
        this.failoverTypes = Output.all(values.asList())
    }

    /**
     * @param values The list of failover types.
     */
    @JvmName("innmaofofcfhfkne")
    public suspend
    fun failoverTypes(values: List<Output<Either<String, ReplicationProtectedItemOperation>>>) {
        this.failoverTypes = Output.all(values)
    }

    /**
     * @param value The action name.
     */
    @JvmName("iluqocjofouipuqh")
    public suspend fun actionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionName = mapped
    }

    /**
     * @param value The custom details.
     */
    @JvmName("ygqipkodadwfbtkw")
    public suspend fun customDetails(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDetails = mapped
    }

    /**
     * @param value The list of failover directions.
     */
    @JvmName("vboelnkfwhgnkxch")
    public suspend
    fun failoverDirections(`value`: List<Either<String, PossibleOperationsDirections>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverDirections = mapped
    }

    /**
     * @param values The list of failover directions.
     */
    @JvmName("mjxjehwcymmciecq")
    public suspend fun failoverDirections(
        vararg
        values: Either<String, PossibleOperationsDirections>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverDirections = mapped
    }

    /**
     * @param value The list of failover types.
     */
    @JvmName("yljmmtaygtttyjve")
    public suspend
    fun failoverTypes(`value`: List<Either<String, ReplicationProtectedItemOperation>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverTypes = mapped
    }

    /**
     * @param values The list of failover types.
     */
    @JvmName("yvwhselqodjcejyb")
    public suspend fun failoverTypes(
        vararg
        values: Either<String, ReplicationProtectedItemOperation>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverTypes = mapped
    }

    internal fun build(): RecoveryPlanActionArgs = RecoveryPlanActionArgs(
        actionName = actionName ?: throw PulumiNullFieldException("actionName"),
        customDetails = customDetails ?: throw PulumiNullFieldException("customDetails"),
        failoverDirections = failoverDirections ?: throw PulumiNullFieldException("failoverDirections"),
        failoverTypes = failoverTypes ?: throw PulumiNullFieldException("failoverTypes"),
    )
}
