@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.RestoreSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Restore Settings  of the vault
 * @property crossSubscriptionRestoreSettings Settings for CrossSubscriptionRestore
 */
public data class RestoreSettingsArgs(
    public val crossSubscriptionRestoreSettings: Output<CrossSubscriptionRestoreSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.RestoreSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.RestoreSettingsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.RestoreSettingsArgs.builder()
            .crossSubscriptionRestoreSettings(
                crossSubscriptionRestoreSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [RestoreSettingsArgs].
 */
@PulumiTagMarker
public class RestoreSettingsArgsBuilder internal constructor() {
    private var crossSubscriptionRestoreSettings: Output<CrossSubscriptionRestoreSettingsArgs>? = null

    /**
     * @param value Settings for CrossSubscriptionRestore
     */
    @JvmName("bjsvselxibuhhxyh")
    public suspend
    fun crossSubscriptionRestoreSettings(`value`: Output<CrossSubscriptionRestoreSettingsArgs>) {
        this.crossSubscriptionRestoreSettings = value
    }

    /**
     * @param value Settings for CrossSubscriptionRestore
     */
    @JvmName("kbasjeiqgdvafejh")
    public suspend
    fun crossSubscriptionRestoreSettings(`value`: CrossSubscriptionRestoreSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSubscriptionRestoreSettings = mapped
    }

    /**
     * @param argument Settings for CrossSubscriptionRestore
     */
    @JvmName("hpljvoodhqxjoisc")
    public suspend
    fun crossSubscriptionRestoreSettings(argument: suspend CrossSubscriptionRestoreSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CrossSubscriptionRestoreSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.crossSubscriptionRestoreSettings = mapped
    }

    internal fun build(): RestoreSettingsArgs = RestoreSettingsArgs(
        crossSubscriptionRestoreSettings = crossSubscriptionRestoreSettings,
    )
}
