@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.SkuArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identifies the unique system identifier for each Azure resource.
 * @property capacity The sku capacity
 * @property family The sku family
 * @property name Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
 * @property size The sku size
 * @property tier The Sku tier.
 */
public data class SkuArgs(
    public val capacity: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<Either<String, SkuName>>,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.SkuArgs =
        com.pulumi.azurenative.recoveryservices.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<Either<String, SkuName>>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The sku capacity
     */
    @JvmName("gsrbiraixpklhccx")
    public suspend fun capacity(`value`: Output<String>) {
        this.capacity = value
    }

    /**
     * @param value The sku family
     */
    @JvmName("xpltsakjffxrtbmn")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
     */
    @JvmName("onrqxxyapatbbjeq")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The sku size
     */
    @JvmName("ajljlweadsicvcoo")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The Sku tier.
     */
    @JvmName("gnjccmyclfyjkyiq")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The sku capacity
     */
    @JvmName("xbgdhveuvqvought")
    public suspend fun capacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The sku family
     */
    @JvmName("brqjuvysjmwwmsea")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
     */
    @JvmName("xcciyxsahfxajype")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
     */
    @JvmName("ipnybonlcehhabae")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
     */
    @JvmName("trbvlxbkygcahcnn")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The sku size
     */
    @JvmName("wbyqqkojlaaofvyy")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The Sku tier.
     */
    @JvmName("yjictbhkjbevmtxm")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
