@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.StorageMappingInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage mapping input properties.
 * @property targetStorageClassificationId The ID of the storage object.
 */
public data class StorageMappingInputPropertiesArgs(
    public val targetStorageClassificationId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.StorageMappingInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.StorageMappingInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.StorageMappingInputPropertiesArgs.builder()
            .targetStorageClassificationId(
                targetStorageClassificationId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StorageMappingInputPropertiesArgs].
 */
@PulumiTagMarker
public class StorageMappingInputPropertiesArgsBuilder internal constructor() {
    private var targetStorageClassificationId: Output<String>? = null

    /**
     * @param value The ID of the storage object.
     */
    @JvmName("qoathxphjhlnsrma")
    public suspend fun targetStorageClassificationId(`value`: Output<String>) {
        this.targetStorageClassificationId = value
    }

    /**
     * @param value The ID of the storage object.
     */
    @JvmName("qjenpmilbrcnqblb")
    public suspend fun targetStorageClassificationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetStorageClassificationId = mapped
    }

    internal fun build(): StorageMappingInputPropertiesArgs = StorageMappingInputPropertiesArgs(
        targetStorageClassificationId = targetStorageClassificationId,
    )
}
